%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Generate histogram
% input: cyc_ampl, cyc_freq  - rainflow_count() returns
%        bin_width           - the width of bin
% output: 'Tj_cycle_histogram.csv' contains two lists
%       bins - amplitude of Tj cycles
%       hists -  number of Tj cycles
% return: bins, hists - histogram bins, number of cycles (list)   
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

function [hists bins] = gen_histogram(cyc_ampl, cyc_freq)
bin_width = 5.0;
% determine the number of bins, N_bin (integer)
N_bin = round(cyc_ampl(1)/bin_width - 0.501) + 1
% bins (a list) of Tj cycles, in acscend order of cycle amplitudes
bins = linspace(bin_width*N_bin, 0, N_bin+1)
% hists (list) number of cycle in each bin 
hists = zeros(1, N_bin);
% count the number of cycles in each bin, 
k = N_bin-1;
i_bin_start = 1;
while k > 0
   for z = 1:length(cyc_ampl)
      if ( cyc_ampl(z) < k*bin_width )
         break
      end % locate i_bin_end
   end 
   i_bin_end = z;
   hists(N_bin - k) = sum(cyc_freq(i_bin_start:i_bin_end-1));
   i_bin_start = i_bin_end;
   k = k-1;
end
hists(end) = sum(cyc_freq(i_bin_start:end));
end