%% extract State-Space Matrices and perform state-space averaging (more information available in the plecsmanual)

%% clering the Matlab Console
clc;

%% Extraction of State-Space Matrices
% get model name
modelName = 'state_space_matrices/Circuit';

% returns a struct contining the names of the components associated with the 
% circtui model's inputs, outputs, states and switches.
names = plecs('get', modelName, 'StateSpaceOrder')

% FET is conducting
% sets the vector of switch positions for the subsequent analysis to [1 0].
plecs('set', modelName, 'SwitchVector', [1 0]);
% returns a struct with the state-space matrices A, B, C, D and I.
t1 = plecs('get', modelName, 'Topology')

% D is conducting
plecs('set', modelName, 'SwitchVector', [0 1]);
t2 = plecs('get', modelName, 'Topology')

%% State-Space Averaging
m = 15/28;
A = t1.A*m + t2.A*(1-m);
B = t1.B*m + t2.B*(1-m);
C = t1.C*m + t2.C*(1-m);
D = t1.D*m + t2.D*(1-m);

%% Open-loop output impedance
%% Comment in the following lines of code
%% if you have a one of the following toolboxes:
%%   - Control System Toolbox
%%   - DSP System Toolbox
%%   - Model Predictive Control Toolbox
%%   - Signal Processing Toolbox
% options = bodeoptions; 
% options.FreqUnits = 'Hz';
% figure;
% bode(ss(A,B(:,2),C(1,:),D(1,2)), options);
% title('Open-loop output impedancev');
% xlim([100, 50000]);
% grid on;
% axes=findobj('type','axes');
% h_magnitude=get(axes(2),'YLabel');
% h_phase=get(axes(1),'YLabel');
% set(h_magnitude,'String','|Z| / dB\Omega');
% set(h_phase,'String','\angle Z / °');

%% Open-loop control-to-output transfer function
%% Comment in the following lines of code
%% if you have a one of the following toolboxes:
%%   - Control System Toolbox
%%   - DSP System Toolbox
%%   - Model Predictive Control Toolbox
%%   - Signal Processing Toolbox
% u = [28; 0];
% B_co = (-(t1.A-t2.A)*(A\B)+(t1.B-t2.B))*u;
% D_co = (-(t1.C-t2.C)*(A\B)+(t1.D-t2.D))*u;
% 
% figure;
% bode(ss(A,B_co,C(1,:),D_co(1)), options);
% title('Open-loop control-to-output transfer function');
% xlim([100, 50000]);
% grid on;
% axes=findobj('type','axes');
% h_magnitude=get(axes(2),'YLabel');
% h_phase=get(axes(1),'YLabel');
% set(h_magnitude,'String','|G| / dB');
% set(h_phase,'String','\angle G / °');

