// Formatting function for row details - modify as you need
function format(d) {
    // `d` is the original data object for the row
   if (d.link === 'none'){
      return (
         '<dl>' +
         '<dt><b>Description:</b></dt>' +
         '<dd class="wrap">' + d.description + '</dd>' +
         '</dl>'
      );
   } else {
      return (
         '<dl>' +
         '<dt><b>Description:</b></dt>' +
         '<dd class="wrap">' + d.description + '</dd>' +
         '<dt><b><a href="' + d.link + '">Link to onlinehelp</a></b></dt>' +
         '<dd></dd>' +
         '</dl>'
      );
   }
}
 
let table = new DataTable('#example', {
   columns: [
      {
         className: 'dt-control',
         orderable: false,
         data: null,
         defaultContent: ''
      },
      {
         data: 'name',
         render: function (data, type) {
            if (type === 'display') {
               if (data[1]==='none'){
                  return data[0];
               } else {
                  return '<div class="wrap"><a href="plecs:' + data[1] + '">' + data[0] + '</a></div>';
               }
            }
            return data;
         }
      },
      { data: 'description' },
      { data: 'topic' }
    ],
    order: [[1, 'asc']],
    columnDefs: [
      {
          target: 2,
          visible: false,
          searchable: true
      }
   ],
   oLanguage: {
      sSearch: "Filter"
   },
   paging: false,  // Disable paging altogether until we figure out how to avoid line break
   pageLength: -1,  // Set "All" as the default
   lengthMenu: [[10, 25, 50, -1], [10, 25, 50, "All"]],  // Customize the length menu
   data: [
      {
         "id":"1",
         "name": ["Using Model Parameters","../examples/features/cscript_parameters.plecs"],
         "description":"An example that shows how to pass parameters to the C-Script block and use them inside the C Code.",
         "link":"qthelp://plexim.com.plecs.1.0/doc/cscripts.html",
         "topic":"C-Script"
      },
      {
         "id":"2",
         "name": ["Basic Vectorization Schemes","../examples/features/vectorization.plecs"],
         "description":"An example that shows how to use the Wire Multiplexer component to get series or parallel connection of physical components. The example also shows how to create copies of a complete circuit using a parameter.",
         "link":"qthelp://plexim.com.plecs.1.0/doc/vectorization.html",
         "topic":"Vectorization"
      },
      {
         "id":"3",
         "name": ["Example Saturation","../examples/features/cscript_example_saturation.plecs"],
         "description":"An example that shows how to implement a saturation block in a C-Script using the <i>ZCSignal</i> macro to define zero-crossing signals.",
         "link":"qthelp://plexim.com.plecs.1.0/doc/cscripts.html",
         "topic":"C-Script"
      },
      {
         "id":"4",
         "name": ["Subsystem Masks","../examples/features/dialog_callback.plecs"],
         "description":"This example gives an overview of the different options in the subsystem mask and how to write LUA code for a custom mask icon.",
         "link":"none",
         "topic":"Component Examples"
      },
      {
         "id":"5",
         "name": ["Times Two Function","../examples/features/cscript_example_times_two.plecs"],
         "description":"An example that uses a C-Script to multiply an input signal of the C-Script block by two. The <i>OutputSignal(i,j)</i> and <i>InputSignal(i,j)</i> macros are used for this purpose.",
         "link":"qthelp://plexim.com.plecs.1.0/doc/cscripts.html",
         "topic":"C-script"
      },
      {
         "id":"6",
         "name": ["State Space Matrices","../examples/features/state_space_matrices.plecs"],
         "description":"An example that shows how to extract the state-space description of a system for different switching combinations.",
         "link":"none",
         "topic":"Scripting"
      },
      {
         "id":"7",
         "name": ["Oven Control","../examples/features/oven_control.plecs"],
         "description":"An example that shows on how to use the Finite State Machine block to implement an oven temperature control. The state machine uses hierarchical states to model the heating and non-heating states of the system.",
         "link":"none",
         "topic":"State Machine"
      },
      {
         "id":"8",
         "name": ["De-Multiplexer","../examples/features/de_multiplexer.plecs"],
         "description":"An example that shows how to use the de-multiplexer component for signals.",
         "link":"none",
         "topic":"Component Examples"
      },
      {
         "id":"9",
         "name": ["C-Script: Zero-Crossing Signals","../examples/features/zero_crossing.plecs"],
         "description":"An example that shows how to integrate a discontinuous function (step function) using the C-Script block. For the implementation the <i>ZCSignal</i> macro is used.",
         "link":"qthelp://plexim.com.plecs.1.0/doc/cscripts.html",
         "topic":"C-Script"
      },
      {
         "id":"10",
         "name": ["Vector Circuits","../examples/features/vector_circuit.plecs"],
         "description":"An example that shows how to vectorize a complete circuit.",
         "link":"qthelp://plexim.com.plecs.1.0/doc/vectorization.html",
         "topic":"Vectorization"
      },
      {
         "id":"11",
         "name": ["Continuous Integrator","../examples/features/cscript_example_integrator.plecs"],
         "description":"An example that shows how to implement an integrator in a C-Script block using the <i>ContState</i> and <i>ContDeriv</i> macros.",
         "link":"qthelp://plexim.com.plecs.1.0/doc/cscripts.html",
         "topic":"C-Script"
      },
      {
         "id":"12",
         "name": ["Step-by-Step Vectorization of RC Chain","../examples/features/vectorization_explanation.plecs"],
         "description":"An example that shows how to vectorize an RC chain using the wire multiplexer component.",
         "link":"qthelp://plexim.com.plecs.1.0/doc/vectorization.html",
         "topic":"Vectorization"
      },
      {
         "id":"13",
         "name": ["Turn-on delay using a C-Script","../examples/features/cscript_example_turnon_delay.plecs"],
         "description":"An example that shows how to implement a turn-on delay in a C-Script block using multiple sample times and the <i>NextSampleHit</i> macro.",
         "link":"qthelp://plexim.com.plecs.1.0/doc/cscripts.html",
         "topic":"C-Script"
      },
      {
         "id":"14",
         "name": ["Analogies Between the Electrical and Mechanical Domain","../examples/features/analogies_el_mech_domain.plecs"],
         "description":"An example that shows the analogy between mechanical and electrical components.",
         "link":"none",
         "topic":"Physical Domains"
      },
      {
         "id":"15",
         "name": ["Example Wrapping Integrator","../examples/features/cscript_example_integrator_wrapping.plecs"],
         "description":"An example that shows how a wrapping integrator can be implemented using the C-Script block and the <i>ContState</i> and <i>ZCSignal</i> macros.",
         "link":"qthelp://plexim.com.plecs.1.0/doc/cscripts.html",
         "topic":"C-Script"
      },
      {
         "id":"16",
         "name": ["Vector Sine Wave","../examples/features/vector_sine_wave.plecs"],
         "description":"An example that shows how to set up a Sine Wave component such that it outputs a bus signal of multiple sine waves with different frequency or phase. This concept can be used for other source blocks in a similar way.",
         "link":"qthelp://plexim.com.plecs.1.0/doc/vectorization.html",
         "topic":"Vectorization"
      },
      {
         "id":"17",
         "name": ["Including External .c and .h Files","../examples/features/cscript_example_external_files.plecs"],
         "description":"An example that shows how to include external .c and .h files into a C-Script block.",
         "link":"qthelp://plexim.com.plecs.1.0/doc/cscripts.html",
         "topic":"C-Script"
      },
      {
         "id":"18",
         "name": ["Sampled Delay","../examples/features/cscript_example_sampled_delay.plecs"],
         "description":"An example that shows how to implement a sampled delay using the C-Script block and the <i>DiscState</i> macro.",
         "link":"none",
         "topic":"Component Examples"
      },
      {
         "id":"19",
         "name": ["Inelastic Collisions","../examples/features/inelastic_collision_example.plecs"],
         "description":"An example that shows how inelastic collisions can be implemented in the mechanical domain.",
         "link":"none",
         "topic":"Physical Domains"
      },
      {
         "id":"20",
         "name": ["Hierarchical Thermal Modelling","../examples/features/hierarchical_thermal_modelling.plecs"],
         "description":"An example that shows how hierarchical thermal structures can be implemented in the thermal domain. This includes components such as the heat sink, thermal resistor, capacitor, thermal ambient tag and component subsystem.",
         "link":"none",
         "topic":"Physical Domains"
      },
      {
         "id":"21",
         "name": ["Fixed-Step Simulation of Diode Rectifier","../examples/features/diode_rectifier_fixed_step.plecs"],
         "description":"An example that shows the simulation of a diode rectifier using a fixed-step solver.",
         "link":"qthelp://plexim.com.plecs.1.0/doc/howplecsworks.html",
         "topic":"Solver Engine"
      },
      {
         "id":"22",
         "name": ["Derivative is infinite or NaN - Example 1","../examples/error_messages/derivative_infinite_nan/division_zero.plecs"],
         "description":"An example that demonstrates how division by zero can lead to this problem and the way it can be resolved.",
         "link":"qthelp://plexim.com.plecs.1.0/doc/errormessages.html",
         "topic":"Error Messages"
      },
      {
         "id":"23",
         "name": ["Derivative is infinite or NaN - Example 2","../examples/error_messages/derivative_infinite_nan/nan_derivative_c_script.plecs"],
         "description":"An example that demonstrates how a NaN value in the derivative function of the C-Script can lead to this problem and the way it can be resolved.",
         "link":"qthelp://plexim.com.plecs.1.0/doc/errormessages.html",
         "topic":"Error Messages"
      },
      {
         "id":"24",
         "name": ["Thermal state derivatives are infinite or NaN","../examples/error_messages/derivative_infinite_nan/thermal_runaway.plecs"],
         "description":"An example that demonstrates how a thermal runaway of the system can lead to this problem and the way it can be resolved.",
         "link":"qthelp://plexim.com.plecs.1.0/doc/errormessages.html",
         "topic":"Error Messages"
      },
      {
         "id":"25",
         "name": ["Electrical state derivatives are infinite or NaN","../examples/error_messages/derivative_infinite_nan/coupling_factor.plecs"],
         "description":"An example that demonstrates how unphysical coupling factors in a transformer can lead to this problem and the way it can be resolved.",
         "link":"qthelp://plexim.com.plecs.1.0/doc/errormessages.html",
         "topic":"Error Messages"
      },
      {
         "id":"26",
         "name": ["Derivative is infinite or NaN - Example 3","../examples/error_messages/derivative_infinite_nan/instable_system.plecs"],
         "description":"An example that demonstrates how a physically instable system can lead to this problem and the way it can be resolved.",
         "link":"qthelp://plexim.com.plecs.1.0/doc/errormessages.html",
         "topic":"Error Messages"
      },
      {
         "id":"27",
         "name": ["Negative loss values for component","../examples/error_messages/negative_losses/negative_losses.plecs"],
         "description":"An example with a semiconductor component that is operated out of range of the specified data in the thermal description.",
         "link":"qthelp://plexim.com.plecs.1.0/doc/errormessages.html",
         "topic":"Error Messages"
      },
      {
         "id":"28",
         "name": ["Encountered 1001 consecutive zero-crossings - Example 1","../examples/error_messages/consecutive_zero_crossings/consecutive_zero_crossings.plecs"],
         "description":"An example that demonstrates how a feedback signal with unlimited bandwidth can cause excessive zero-crossings and the way it can be resolved.",
         "link":"qthelp://plexim.com.plecs.1.0/doc/errormessages.html",
         "topic":"Error Messages"
      },
      {
         "id":"29",
         "name": ["Encountered 1001 consecutive zero-crossings - Example 2","../examples/error_messages/consecutive_zero_crossings/consecutive_zero_crossings_pmsm.plecs"],
         "description":"An example that demonstrates how a PMSM implemented in a Rotating Reference Frame (RRF) and a converter in rectifier mode can cause this problem and the way it can be resolved.",
         "link":"qthelp://plexim.com.plecs.1.0/doc/errormessages.html",
         "topic":"Error Messages"
      },
      {
         "id":"30",
         "name": ["State/source dependence in components - Example 1","../examples/error_messages/state_source_dependency/state_source_dependency_typical.plecs"],
         "description":"An example that shows typical reasons for this error and how to resolve it.",
         "link":"qthelp://plexim.com.plecs.1.0/doc/errormessages.html",
         "topic":"Error Messages"
      },
      {
         "id":"31",
         "name": ["State/source dependence in components - Example 2","../examples/error_messages/state_source_dependency/state_source_dependency_errors.plecs"],
         "description":"An example that shows the possible state/source dependencies for the different Physical Domains in PLECS.",
         "link":"qthelp://plexim.com.plecs.1.0/doc/errormessages.html",
         "topic":"Error Messages"
      },
      {
         "id":"32",
         "name": ["State/source dependence in components - Example 3","../examples/error_messages/state_source_dependency/state_source_dependency_solution_electrical.plecs"],
         "description":"An example that shows typical state/source dependencies in models of power electronic systems.",
         "link":"qthelp://plexim.com.plecs.1.0/doc/errormessages.html",
         "topic":"Error Messages"
      },
      {
         "id":"33",
         "name": ["Could not solve the algebraic loop - Example 1","../examples/error_messages/algebraic_loop/algebraic_loop_error.plecs"],
         "description":"An example that shows a possible reason for this error and how to resolve it by restricting the operating range of the circuit.",
         "link":"qthelp://plexim.com.plecs.1.0/doc/howplecsworks.html",
         "topic":"Error Messages"
      },
      {
         "id":"34",
         "name": ["Could not solve the algebraic loop - Example 2","../examples/error_messages/algebraic_loop/algebraic_loop_how_to_break_loops.plecs"],
         "description":"An example that explains how to break an algebraic loop using either a reformulation of the equations, a delay block or a low pass filter.",
         "link":"qthelp://plexim.com.plecs.1.0/doc/errormessages.html",
         "topic":"Error Messages"
      },
      {
         "id":"35",
         "name": ["Could not solve the algebraic loop - Example 3","../examples/error_messages/algebraic_loop/algebraic_loop_initial_condition.plecs"],
         "description":"An example that shows a possible reason for this error and how to resolve it using the right initial conditions.",
         "link":"none",
         "topic":"Error Messages"
      },
      {
         "id":"36",
         "name": ["State discontinuity after switching - Example 1","../examples/error_messages/state_discontinuity/additional_resistance.plecs"],
         "description":"Adding an on-resistance to the switching elements prevents the short circuit of the switch output capacitance.",
         "link":"qthelp://plexim.com.plecs.1.0/doc/errormessages.html",
         "topic":"Error Messages"
      },
      {
         "id":"37",
         "name": ["State discontinuity after switching - Example 2","../examples/error_messages/state_discontinuity/inductive_switching.plecs"],
         "description":"An example that demonstrates how the interruption of inductive current can cause this problem and the way it can be resolved.",
         "link":"qthelp://plexim.com.plecs.1.0/doc/errormessages.html",
         "topic":"Error Messages"
      },
      {
         "id":"38",
         "name": ["State discontinuity after switching - Example 3","../examples/error_messages/state_discontinuity/boost_converter_multiplier.plecs"],
         "description":"Adding an on-resistance to the switching elements prevents the short circuit of the capacitor in a boost converter circuit.",
         "link":"qthelp://plexim.com.plecs.1.0/doc/errormessages.html",
         "topic":"Error Messages"
      },
      {
         "id":"39",
         "name": ["State discontinuity after switching - Example 4","../examples/error_messages/state_discontinuity/relative_tolerance.plecs"],
         "description":"An example that shows that this error can be resolved by decreasing the relative tolerance in the solver settings.",
         "link":"qthelp://plexim.com.plecs.1.0/doc/errormessages.html",
         "topic":"Error Messages"
      },
      {
         "id":"40",
         "name": ["State discontinuity after switching - Example 5","../examples/error_messages/state_discontinuity/topological_error.plecs"],
         "description":"An example that shows a case in which the error is caused by a wrong modulation of the converter.",
         "link":"qthelp://plexim.com.plecs.1.0/doc/errormessages.html",
         "topic":"Error Messages"
      },
      {
         "id":"41",
         "name": ["Polar To Rectangular","../examples/component_help/polar_to_rectangular.plecs"],
         "description":"An example that demonstrates the basic usage of this component.",
         "link":"none",
         "topic":"Component Examples"
      },
      {
         "id":"42",
         "name": ["Rectangular To Polar","../examples/component_help/rectangular_to_polar.plecs"],
         "description":"An example that shows the implementation of a simplified PLL component using the Polar to Rectangular component.",
         "link":"none",
         "topic":"Component Examples"
      },
      {
         "id":"43",
         "name": ["Sine Wave Generator","../examples/component_help/sine_wave_generator.plecs"],
         "description":"An example that shows how to set up a Sine Wave component such that it outputs a bus signal of multiple sine waves with different frequency or phase.",
         "link":"none",
         "topic":"Component Examples"
      },
      {
         "id":"44",
         "name": ["Zero Order Hold","../examples/component_help/zero_order_hold.plecs"],
         "description":"An example that demonstrates the basic usage of this component.",
         "link":"none",
         "topic":"Component Examples"
      },
      {
         "id":"45",
         "name": ["Continuous Transfer Function","../examples/component_help/continuous_transfer_function.plecs"],
         "description":"An example that demonstrates how to implement a high- and low-pass filter with this component.",
         "link":"none",
         "topic":"Component Examples"
      },
      {
         "id":"46",
         "name": ["Triggered Subsystem","../examples/component_help/triggered_subsystem.plecs"],
         "description":"An example that shows how an edge counter and signal sampling can be implemented with this component.",
         "link":"none",
         "topic":"Component Examples"
      },
      {
         "id":"47",
         "name": ["Total Harmonic Distortion","../examples/component_help/total_harmonic_distortion.plecs"],
         "description":"An example that demonstrates the basic usage of this component.",
         "link":"none",
         "topic":"Component Examples"
      },
      {
         "id":"48",
         "name": ["Enabled Subsystem","../examples/component_help/enabled_subsystem.plecs"],
         "description":"An example that demonstrates the basic usage of this component.",
         "link":"none",
         "topic":"Component Examples"
      },
      {
         "id":"49",
         "name": ["Turn-on Delay","../examples/component_help/turn_on_delay.plecs"],
         "description":"An example that shows the basic usage of this component and the difference to a Pulse Delay block.",
         "link":"none",
         "topic":"Component Examples"
      },
      {
         "id":"50",
         "name": ["Variable Inductor","../examples/component_help/variable_inductor.plecs"],
         "description":"An example that shows the basic usage of this component and the difference between an incremental and total inductance.",
         "link":"none",
         "topic":"Component Examples"
      },
      {
         "id":"51",
         "name": ["Mutual Inductor","../examples/component_help/mutual_inductor.plecs"],
         "description":"An example that shows the basic usage of this component.",
         "link":"none",
         "topic":"Component Examples"
      },
      {
         "id":"52",
         "name": ["Lookup Table","../examples/component_help/lookup_table.plecs"],
         "description":"An example that demonstrates the basic usage of this component.",
         "link":"none",
         "topic":"Component Examples"
      },
      {
         "id":"53",
         "name": ["Pulse Delay","../examples/component_help/pulse_delay.plecs"],
         "description":"An example that shows when to use a Pulse Delay block and when not.",
         "link":"none",
         "topic":"Component Examples"
      },
      {
         "id":"54",
         "name": ["Algebraic Constraint","../examples/component_help/algebraic_constraint.plecs"],
         "description":"An example that shows how to solve a system of coupled non-linear equations.",
         "link":"none",
         "topic":"Component Examples"
      },
      {
         "id":"55",
         "name": ["Multiport Signal Switch","../examples/component_help/multiport_signal_switch.plecs"],
         "description":"An example that demonstrates the basic usage of this component.",
         "link":"none",
         "topic":"Component Examples"
      },
      {
         "id":"56",
         "name": ["Discrete Transfer Function","../examples/component_help/discrete_transfer_function.plecs"],
         "description":"An example that demonstrates how to implement a high- and low-pass filter with this component.",
         "link":"none",
         "topic":"Component Examples"
      },
      {
         "id":"57",
         "name": ["Algebraic Component","../examples/component_help/algebraic_component.plecs"],
         "description":"An example that shows how to implement a constant power load and variable resistor with this component.",
         "link":"none",
         "topic":"Component Examples"
      },
      {
         "id":"58",
         "name": ["Delay","../examples/component_help/delay.plecs"],
         "description":"An example that shows how to implement a FIR filter with this component.",
         "link":"none",
         "topic":"Component Examples"
      },
      {
         "id":"59",
         "name": ["Transport Delay","../examples/component_help/transport_delay.plecs"],
         "description":"An example that shows when to use this component and when not.",
         "link":"none",
         "topic":"Component Examples"
      },
      {
         "id":"60",
         "name": ["Rms Value","../examples/component_help/rms_value.plecs"],
         "description":"An example that demonstrates the basic usage of this component.",
         "link":"none",
         "topic":"Component Examples"
      },
      {
         "id":"61",
         "name": ["Custom Variables in Thermal Descriptions","../examples/component_help/thermal_custom_variable.plecs"],
         "description":"An example that demonstrates the usage of either a static value or a Signal Goto tag as the custom variable inside a thermal description.",
         "link":"qthelp://plexim.com.plecs.1.0/doc/thermalmodeling.html",
         "topic":"Component Examples"
      }
   ],
});
 
// Add event listener for opening and closing details
table.on('click', 'td.dt-control', function (e) {
    let tr = e.target.closest('tr');
    let row = table.row(tr);
 
    if (row.child.isShown()) {
        // This row is already open - close it
        row.child.hide();
    }
    else {
        // Open this row
        row.child(format(row.data())).show();
    }
});