function ret = plerrorfcn(varargin)

handle = varargin{1};
if (nargin >= 3),
    origError = varargin{3};
    if strcmp(get_param(origError.handles{1}, 'BlockType'), 'S-Function'),
        %
        % if the error stems from our plecs Mex-function, chop off the first line,
        % which just says "Error occurred in '.../ S-Function '."
        %
        msg = origError.message;
        firstNewlineIdx = find(msg == char(10), 1);
        if ~isempty(firstNewlineIdx),
            msg = msg(firstNewlineIdx+1:end);
        end
        ret = msg;
    else
        ret = origError;
    end
else
    if nargin == 1,
        simErrMsg = '';
    elseif nargin == 2,
        simErrMsg = varargin{2};
    end
    ret = plecs('sl', 213, handle, simErrMsg);
end