function B = plrot90(A, k)

if ndims(A)>3, error('A must be a 3-D matrix.'); end

[m,n,o] = size(A);
if nargin == 1
    k = 1;
else
    if length(k)~=1, error('k must be a scalar.'); end
    k = rem(k,4);
    if k < 0
        k = k + 4;
    end
end

for i = 1:o,
  a = A(:,:,i);
  if (k == 1)
    b = a(m:-1:1,:);
    b = b.';
  elseif (k == 2)
    b = a(m:-1:1,n:-1,1);
  elseif (k == 3)
    a = a.';
    b = a(n:-1:1,:);
  else
    b = a;
  end
  B(:,:,i) = b;
end
