function [RL, K] = plrrdiode(If0, dIrdt, trr, Irrm, Qrr, Lrr)

dIrdt = abs(dIrdt);
if ~trr && Irrm && Qrr,
  if ~(Qrr>Irrm^2/2/dIrdt) ,
    error('Parameters for reverse recovery must satisfy: 2*Qrr * dIr/dt > Irrm^2');
  end
  trr = log(10)/Irrm * (Qrr-(.5-1/log(10))/dIrdt*Irrm^2);
elseif trr && ~Irrm && Qrr,
  if ~(Qrr<trr^2/2*dIrdt) ,
    error('Parameters for reverse recovery must satisfy: 2*Qrr < trr^2 * dIr/dt');
  end
  Irrm = -trr*dIrdt/(log(10)-2) + sqrt((trr*dIrdt/(log(10)-2))^2 + Qrr*dIrdt/(.5-1/log(10)));
elseif trr && Irrm,
  if ~(Irrm<trr*dIrdt) ,
    error('Parameters for reverse recovery must satisfy: Irrm < trr * dIr/dt');
  end
  Qrr = (.5-1/log(10))/dIrdt*Irrm^2 + trr/log(10)*Irrm;
else
    error('Two of the parameters trr, Irrm, Qrr must be non-zero.');
end
RL = Lrr * log(10) / (trr - Irrm/dIrdt);

% Solve for K using Newton-Raphson
x = 0;
iter = 1;
maxIter = 100;
tol = 1e-10;
while iter < maxIter,
  y = Irrm/Lrr/dIrdt / (1 - exp( -(If0+Irrm)/(Lrr*dIrdt*(x+1/RL))));
  dy = y-x;
  relErr = abs(dy)/max(abs(x),abs(y));
  if (relErr < tol),
    break;
  end
  dydx = (Irrm/Lrr/dIrdt*(If0+Irrm)*exp((If0+Irrm)/(Lrr*dIrdt*(1/RL+x)))) ...
       / (Lrr*dIrdt*(1/RL+x)^2*(exp((If0+Irrm)/(Lrr*dIrdt*(1/RL+x)))-1)^2) ...
       - 1;
  if isnan(dydx),
    % dydx may become NaN for large arguments to exp. In this case, set it to -1,
    % which means essentially that the function is horizontal in this point.
    dydx = -1;
  end
  dx = dy/dydx;
  x = x-dx;
  iter = iter + 1;
end
if (iter >= maxIter)
  error('Fatal error: Newton-Raphson iteration failed');
end

K = x;
