#include "plecsrtw.h"
#include <math.h>

double plecsmod(double a, double b)
{
   if (!b)
   {
      return a;
   }
   else
   {
      double r = fmod(a, b);
      if ((r < 0 && b > 0) || (r > 0 && b < 0))
         r += b;
      return r;
   }
}

size_t findIndex(const double *xVec, size_t numX, double x,
                 double* fraction)
{
   size_t idx = 0;
   size_t top = numX;
   size_t bottom = 0;
   while (top > bottom)
   {
      size_t mid = (bottom+top)/2;
      if (xVec[mid] < x)
      {
         bottom = mid+1;
      }
      else
      {
         top = mid;
      }
   }
   idx = bottom;
   if (idx+2 > numX)
   {
      idx = numX-2;
   }
   else if (idx > 0 && xVec[idx] > x)
   {
      --idx;
   }
   if (xVec[idx] == xVec[idx+1])
   {
      if (idx+2 < numX && xVec[idx] == xVec[idx+2])
      {
         ++idx;
         *fraction = 0.0;
      }
      else
      {
         if (x > 0)
         {
            *fraction = 0.0;
         }
         else if (x < 0)
         {
            *fraction = 1.0;
         }
         else
         {
            *fraction = 0.5;
         }
      }
   }
   else
   {
      *fraction = (x-xVec[idx])/(xVec[idx+1]-xVec[idx]);
   }
   return idx;
}

static double plecsinterp(double frac, double val0, double val1)
{
   return (val0 == val1) ? val0 : (1-frac)*val0 + frac*val1;
}

double plecslu1d(plecsLUT *lut, double x)
{
   double xFrac = 0.;
   size_t xIdx = findIndex(lut->xVec, lut->numX, x, &xFrac);
   return plecsinterp(xFrac, lut->data[xIdx], lut->data[xIdx+1]);
}

#define DATA2D(x,y) lut->data[(xIdx+(x))*lut->numY+yIdx+(y)]

double plecslu2d(plecsLUT *lut, double x, double y)
{
   double xFrac = 0., yFrac = 0.;
   double outX1, outX2;
   size_t xIdx, yIdx;
   
   xIdx = findIndex(lut->xVec, lut->numX, x, &xFrac);
   yIdx = findIndex(lut->yVec, lut->numY, y, &yFrac);
   
   outX1 = plecsinterp(yFrac, DATA2D(0,0), DATA2D(0,1));
   outX2 = plecsinterp(yFrac, DATA2D(1,0), DATA2D(1,1));
   
   return plecsinterp(xFrac, outX1, outX2);
}

#define DATA3D(x,y,z) \
   lut->data[((xIdx+(x))*lut->numY+(yIdx+(y)))*lut->numZ+zIdx+(z)]
                              
double plecslu3d(plecsLUT *lut, double x, double y, double z)
{
   double xFrac = 0., yFrac = 0., zFrac = 0.;
   double outX1Y1, outX2Y1, outX1Y2, outX2Y2;
   double outX1, outX2;
   size_t xIdx, yIdx, zIdx;
   
   xIdx = findIndex(lut->xVec, lut->numX, x, &xFrac);
   yIdx = findIndex(lut->yVec, lut->numY, y, &yFrac);
   zIdx = findIndex(lut->zVec, lut->numZ, z, &zFrac);
   
   outX1Y1 = plecsinterp(zFrac, DATA3D(0,0,0), DATA3D(0,0,1));
   outX2Y1 = plecsinterp(zFrac, DATA3D(1,0,0), DATA3D(1,0,1));
   outX1Y2 = plecsinterp(zFrac, DATA3D(0,1,0), DATA3D(0,1,1));
   outX2Y2 = plecsinterp(zFrac, DATA3D(1,1,0), DATA3D(1,1,1));
   
   outX1 = plecsinterp(yFrac, outX1Y1, outX1Y2);
   outX2 = plecsinterp(yFrac, outX2Y1, outX2Y2);
   
   return plecsinterp(xFrac, outX1, outX2);
}
