#ifndef PLECSRTW_H_
#define PLECSRTW_H_

#include <stddef.h>

typedef struct {
   const size_t numX, numY, numZ;
   const double *xVec, *yVec, *zVec, *data;
} plecsLUT;

extern double plecsmod(double, double);

extern double plecslu1d(plecsLUT *, double);

extern double plecslu2d(plecsLUT *, double, double);

extern double plecslu3d(plecsLUT *, double, double, double);

struct CScriptStruct
{
   int numInputTerminals;
   int numOutputTerminals;
   int* numInputSignals;
   int* numOutputSignals;
   int numContStates;
   int numDiscStates;
   int numZCSignals;
   int numSampleTimes;
   int numParameters;
   int isMajorTimeStep;
   double time;
   const double ***inputs;
   double ***outputs;
   double *contStates;
   double *contDerivs;
   double *discStates;
   double *zCSignals;
   const int *paramNumDims;
   const int **paramDims;
   const int *paramNumElements;
   const double **paramRealData;
   const char **paramStringData;
   const char * const *sampleHits;
   const double *sampleTimePeriods;
   const double *sampleTimeOffsets;
   double *nextSampleHit;
   const char** errorStatus;
   const char** warningStatus;
   const char** rangeErrorMsg;
   int* rangeErrorLine;
};

struct FSM_Struct
{
   int fsm_isMajorTimeStep;
   double fsm_currentTime;
   const double *fsm_internalConstants;
   const double ***fsm_inputs;
   double ***fsm_outputs;
   double *fsm_discStates;
   double *fsm_zCSignals;
   int *fsm_takenTransitions;
   double *fsm_nextSampleHit;
   double fsm_samplingFrequency;
   const char **fsm_errorStatus;
   const char **fsm_warningStatus;
};

#endif
