%PLSATURATION Plotting Tool for PLECS Machine Saturation
%
% PLSATURATION(Lm0, Lmsat, PsiT, fT) plots the main flux and the magnetization
% inductance vs. current for the parameters specified:
%
%  Lm0:   Unsaturated magnetizing inductance [H]
%  Lmsat: Saturated magnetizing inductance [H]
%  PsiT:  Magnetizing flux at saturation transition [Wb]
%  fT:    Tightness of saturation transition [1]

% (c) 2006, Plexim GmbH

function plsaturation(Lm0, Lmsat, PsiT, fT)

iT = 1/Lm0*PsiT;
Psimax = 4*iT*Lmsat+PsiT
Psim = [0:0.002:1]*Psimax;
     
tauT = fT / PsiT * Lm0/Lmsat;
Mf = 1/Lmsat;
Mi = (1/Lm0 - 1/Lmsat*(.5-atan(tauT*PsiT)/pi))/(.5+atan(tauT*PsiT)/pi);
im = (Mf-Mi)/pi*( ((Psim-PsiT).*atan(tauT*(Psim-PsiT)) - PsiT*atan(tauT*PsiT)) + .5/tauT*(log(1+(tauT*PsiT)^2) - log(1+tauT^2*(Psim-PsiT).^2)) ) + Psim.*(Mf+Mi)/2;
Lm = 1./((Mf-Mi)/pi*atan(tauT*(Psim-PsiT))+(Mf+Mi)/2);

figure;
subplot(2,1,1);
plot(im,Psim);
ylabel('\Psi_m');
set(gca, 'XTickLabel', '');
grid on;
subplot(2,1,2);
plot(im,Lm);
xlabel('i_m');
ylabel('L_m');
grid on;
