function [TsNative, TsThermal] = plDetermineTaskSampleTimes()

currentCircuit = plecs('get', '', 'CurrentCircuit');
aggregationMode = plecs('get', currentCircuit, 'AggregationMode');
target = plecs('get', '.', 'CompiledCodeGenTarget');

% Default: inherited
TsNative = [-1, 0];

% When generating code, use the base sample time by default.
if ~isempty(fieldnames(target)) && any(strcmp(aggregationMode, {'CodeGen', 'ExtMode'})),
   TsNative = [target.Variables.SAMPLE_TIME, 0];
end

% If multi-tasking is configured, use the task sample time.
task = plecs('get', '.', 'CompiledTask');
if isfield(task, 'SampleTime')
   TsNative = task.SampleTime;
end

TsThermal = TsNative;

% If there is a dedicated thermal task, use its sample time.
if isfield(target, 'TaskConfigurations'),
   for task = target.TaskConfigurations'
      if task{1}.isThermal,
         TsThermal = task{1}.SampleTime;
         break;
      end
   end
end

end
