
% Parameter Sweep of a Buck Converter
% Use with buck_converter_with_parameter_sweep.mdl demo model

% create path to scope
scope = 'buck_converter_with_parameter_sweep/Circuit/Scope';

% clear all previous traces in scope 'Scope' in the current model
plecs('scope', scope, 'ClearTraces');

% parametric values to be swept
inductorValues = [40:20:220]; % in uH

for ix = 1:length(inductorValues)
  % set value for L1
  varL = inductorValues(ix) * 1e-6;
  % start simulation, return probed signal values to workspace using Output port 'Out1'
  [t, x, y] = sim('buck_converter_with_parameter_sweep');
  % hold and label traces in scope
  plecs('scope', scope, 'HoldTrace',['L=' mat2str(inductorValues(ix)) 'uH']);
  % find maximum current value and index
  [maxv, maxidx] = max(y(:,1));
  % Output maximum current values to MATLAB console
  fprintf('Max current for L=%duH: %fA at %fs\n', inductorValues(ix), maxv, t(maxidx));
end