%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% predict lifetime
% input: 
%        - t_period: time period of load cycle
%        - Nf_a & Nf_b: lifetime model parameters
%        - hist_cycle_number:
%        - hist_bin: 
% return: lifetime in years
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

function lifetime = predict_lifetime(t_period,Nf_a,Nf_b,hists,bins)
   % lifetime model parameters
   % Nf = Nf_a*(delta Tj)^(-Nf_b)
   N_bin_lifetime = length(hists);
   % acc_damage (list) stores damages of cycles in bins
   acc_damage = zeros(1, N_bin_lifetime);
   k_lifetime = 1;
   while k_lifetime <= N_bin_lifetime
      acc_damage(k_lifetime) = hists(k_lifetime)/(Nf_a*power(bins(k_lifetime), -Nf_b));
      k_lifetime = k_lifetime + 1;
   end
   % calculate the accumulated damage in a load cycle
   % Miner's rule (linear damage accumulation)
   % number of this load cycle to failure
   PC = 1/sum(acc_damage);
   % lifetime (year)
   lifetime = PC*t_period/3600/24/365;
end