function makecfg(objBuildInfo)
    rtwIsRSimTarget = false;
    plecsRSimTarget = false;
    plecsRealTimeTarget = false;

    % check what Simulink is building for
    switch get_param(bdroot, 'RTWSystemTargetFile')
        case 'accel.tlc'
            return;
        case {'raccel.tlc', 'rtwsfcn.tlc'}
            rtwIsRSimTarget = true;
        case 'rsim.tlc'
            rtwIsRSimTarget = true;
    end


    % check the individual target settings of the circuit blocks
    circuits = find_system(bdroot, ...
        'FollowLinks', 'on', ...
        'LookUnderMasks', 'all', ...
        'MaskType', 'PlecsCircuit');
    for circuit = circuits'
        cctTarget = plecs('get', char(circuit), 'RTWTarget');
        if strcmp(cctTarget,'RSim') || (~strcmp(cctTarget,'RealTime') && rtwIsRSimTarget)
            plecsRSimTarget = true;
        else
            plecsRealTimeTarget = true;
        end
    end

    if plecsRSimTarget
        [libDir, dllDir, libName] = iRSimDetermineLibDirAndName;
        if strncmpi(computer, 'pc', 2)
            envVar = 'PATH';
            p = getenv(envVar);
            if ~any(strfind(p, dllDir))
                setenv(envVar, [p pathsep dllDir]);
            end
        end
        addLinkFlags(objBuildInfo, sprintf('-Wl,-rpath,%s',  dllDir), 'ADDITIONAL_LDFLAGS');
        addLinkObjects(objBuildInfo, libName, fullfile(libDir), 1000, true, true);
    end

    if plecsRealTimeTarget
        plecsRoot = fileparts(which('plecs'));
        srcDir = RTW.transformPaths(fullfile(plecsRoot, 'rtw', 'src', ''));
        addIncludePaths(objBuildInfo, srcDir);
        addSourceFiles(objBuildInfo, {'plecsrtw.c'}, {srcDir});
    end
end
% end function


%
% determine the architecture and the name of the dynamic library
%
function [libDir, dllDir, libName] = iRSimDetermineLibDirAndName

    plecsRoot = fileparts(which('plecs'));
    binDir = fullfile(plecsRoot, 'bin', '');
    switch mexext
        case {'mexw32', 'dll'}
            libName = 'plecsrsim.lib';
            dllDir = fullfile(binDir, 'win32', '');
            compiler = plcheckmex;
            if strcmp(compiler, 'lcc')
                libDir = fullfile(dllDir, 'lcc', '');
            else
                if ~strcmp(compiler, 'cl')
                    warning('Unknown compiler ''%s''. Using MSVC import library for plecsrsim.dll.', compiler); %#ok<WNTAG>
                end
                libDir = fullfile(dllDir, 'msvc', '');
            end
        case 'mexw64'
            libName = 'plecsrsim.lib';
            dllDir = fullfile(binDir, 'win64', '');
            compiler = plcheckmex;
            if any(strfind(compiler, 'mingw'))
                libDir = fullfile(dllDir, 'mingw', '');
            else
                if ~strcmp(compiler, 'cl')
                    warning('Unknown compiler ''%s''. Using MSVC import library for plecsrsim.dll.', compiler); %#ok<WNTAG>
                end
                libDir = fullfile(dllDir, 'msvc', '');
            end
        case 'mexmaci'
            libName = 'libplecsrsim.dylib';
            dllDir = fullfile(binDir, 'maci', '');
            libDir = dllDir;
        case 'mexmaci64'
            libName = 'libplecsrsim.dylib';
            dllDir = fullfile(binDir, 'maci64', '');
            libDir = dllDir;
        case 'mexmaca64'
            libName = 'libplecsrsim.dylib';
            dllDir = fullfile(binDir, 'maca64', '');
            libDir = dllDir;
        case 'mexglx'
            libName = 'libplecsrsim.so';
            dllDir = fullfile(binDir, 'glnx86', '');
            libDir = dllDir;
        case 'mexa64'
            libName = 'libplecsrsim.so';
            dllDir = fullfile(binDir, 'glnxa64', '');
            libDir = dllDir;
        otherwise
            error('Unsupported architecture for RSim target');
    end
    dllDir = RTW.transformPaths(dllDir);
    libDir = RTW.transformPaths(libDir);
end
% end function
