function varargout = plecs(varargin)
%PLECSEDIT Command Line Interface for PLECS.
%
% PLECSEDIT('CMD','PARAMETER1','PARAMETER2',...) allows you to access PLECS
% component and circuit parameters directly from the MATLAB command line.
% 'CMD' is one of the following commands:  get, set, hostid.
%
% PLECSEDIT('get','COMPONENT_PATH',['PARAMETER']) returns the value of
% PARAMETER of the PLECS component indicated by the COMPONENT_PATH as a string.
% If PARAMETER is omitted a cell aray with all available parameters is returned.
%
% PLECSEDIT('set','COMPONENT_PATH', 'PARAMETER', 'VALUE') set the value of
% PARAMETER of the PLECS component indicated by the COMPONENT_PATH to 'VALUE'.
%
% PLECSEDIT('hostid') prints the hostid information.
%
% Examples:
%
% plecs('get', 'mdl/Circuit1')          % returns the parameters of Circuit1
%                                           % in the simulink model mdl
%
% plecs('get', 'mdl/Circuit1', 'Name')  % returns the name of Circuit1
%
% plecs('get', 'mdl/Circuit1', 'CircuitModel')
%                                           % returns the circuit simulation
%                                           % method of Circuit1
%
% plecs('get', 'mdl/Circuit1/R1')       % returns the parameters of component
%                                           % R1 in circuit Circuit1
%
% plecs('set', 'mdl/Circuit1/R1', 'R', '2')
%                                           % sets the resistance of component
%                                           % R1 in circuit Circuit1 to 2

plecsext = mexext;
if strcmp(plecsext, 'w32'),
  plecsext = 'dll';
end

mypath = fileparts(which('plecs'));
filter = fullfile(mypath, 'plecs.*');
files = dir(filter);

errormsg = sprintf('PLECS requires the MEX function ''plecs.%s'' to be installed on your computer. However, the PLECS directory ''%s'' only contains these files:', plecsext, mypath);
for idx = 1:length(files),
  errormsg = sprintf('%s\n  %s', errormsg, files(idx).name);
end

errordlg(errormsg, 'PLECS was not installed properly', 'modal');
error('PLECS was not installed properly:\n%s\n', errormsg);
