function plecsclear
%PLECSCLEAR   Close all models containing PLECS blocks and clear the module
%   PLECSCLEAR closes all Simulink models that contain blocks from the PLECS
%   library. If a model has been modified, PLECSCLEAR will ask for confirmation
%   before closing the model.
%   Upon successful clearing PLECS will issue the message "Cleared PLECS module"

%   Copyright 2004 - 2015 Plexim GmbH

%
% check whether plecs has actually been loaded
%
[m, mex] = inmem;
if ~any(strcmp('plecs', mex)),
  return
end

%
% clear it
%
plecs clear
clear plecs

%
% check whether plecs was actually cleared
%
[m, mex] = inmem;
if any(strcmp('plecs', mex)),
  warndlg(['The PLECS module cannot be cleared because it is still ' ...
           'locked for some reason. To force clearing the module, run ' ...
           'the following commands:' char(10) char(10) ...
           '   plecs  clear  force' char(10) ...
           '   clear  plecs'], ...
           'Unable to clear PLECS', ...
           'modal');
end
