function compiler = plcheckmex

compiler = 'unknown';

testPath = fullfile(fileparts(mfilename('fullpath')), 'test.c');

oldwd = pwd;
cd(tempdir);
try
  result = evalc(['mex(''-v'', ''-n'', ''' testPath ''')']);
catch
  result = '';
end
cd(oldwd);

while ~isempty(result),
  [line, result] = strtok(result, char(10)); %#ok<STTOK>
  if strfind(line, 'COMPILER '),
    sepIdx = strfind(line, '=');
    if isempty(sepIdx),
      sepIdx = strfind(line, ':');
    end
    if ~isempty(sepIdx),
      compiler = line((sepIdx+1):end);
      compiler = lower(deblank(fliplr(deblank(fliplr(compiler)))));
      return;
    end
  end
end

warning('Could not determine the compiler used by MEX.'); %#ok<WNTAG>
