function wsout = pleval(wsin, expr, flag)

try
    wsout = iAssignEvalAndWho(wsin, expr, flag);
catch ME
    throwAsCaller(ME)
end



function wsout = iAssignEvalAndWho(wsin, expr, flag)

% first of all, make a clean slate in the caller workspace
evalin('caller', 'clear');

% next, assign the ws-variables passed via the wsin-struct
vars = fieldnames(wsin);
for idx = 1:length(vars)
    assignin('caller', vars{idx}, getfield(wsin, vars{idx}));
end

if (flag)
    % now evaluate the expression
    evalin('caller', expr);

    % finally, accumulate the wsout-struct
    wsout = [];
    vars = evalin('caller', 'who');
    for idx = 1:length(vars)
        wsout = setfield(wsout, vars{idx}, evalin('caller', vars{idx}));
    end
else
    wsout = evalin('caller', expr);
end
