function out = plfmttbl(in, tblName, idxNames, expandIdx)

if nargin < 4,
  expandIdx = 1;
end

errMsgFormat = ['Loss table must be specified either as a scalar ' ...
  'value or as a struct with the fields ''' tblName ''' and zero or more of '];
for idx = 1:length(idxNames),
  if (idx > 1),
    errMsgFormat = [errMsgFormat ','];
  end
  errMsgFormat = [errMsgFormat ' ''' idxNames{idx} ''''];
end
errMsgFormat = [errMsgFormat '.'];

% shortcut non-struct definition
if ~isstruct(in),
  if isempty(in),
    out = [];
    return;
  elseif isnumeric(in),
    if prod(size(in)) == 1,
      if expandIdx,
        out = struct(tblName, repmat(double(in), repmat(2, 1, length(idxNames))));
        for idx = 1:length(idxNames),
          out = setfield(out, idxNames{idx}, [0 0]);
        end
      else
        out = struct(tblName, double(in));
        for idx = 1:length(idxNames),
          out = setfield(out, idxNames{idx}, 0);
        end
      end
      return;
    end
  end
  error(errMsgFormat);
end

% check whether tblName is present
if ~isfield(in, tblName),
  error(errMsgFormat);
end

% extract the field tblName from the struct and check the type
tbl = getfield(in, tblName);
in = rmfield(in, tblName);
if ~isnumeric(tbl),
  error(['Field ''' tblName ''' must be numeric.']);
end
tbl = double(tbl);

idxVec = cell(size(idxNames));
idxDim = zeros(size(idxNames));
dimCount = 0;
for idx = 1:length(idxNames),
  if isfield(in, idxNames{idx}),
    % extract the field from the struct
    idxVec{idx} = getfield(in, idxNames{idx});
    in = rmfield(in, idxNames{idx});
    if ~isnumeric(idxVec{idx}),
      error(['Field ''' idxNames{i} ''' must be numeric.']);
    end
    if sum(size(idxVec{idx})>1) > 1,
      error(['Field ''' idxNames{idx} ''' must be a vector.']);
    end
    idxVec{idx} = double(idxVec{idx}(:));
    % record the corresponding dimension in the input table
    dimCount = dimCount + 1;
    idxDim(idx) = dimCount;
  end
end

% shortcut: no indices
if ~dimCount,
  if prod(size(tbl)) ~= 1,
    error(['''' tblName ''' must be scalar if there are no index vectors defined.']);
  end
  if expandIdx,
    out = struct(tblName, repmat(tbl, repmat(2, 1, length(idxNames))));
    for idx = 1:length(idxNames),
      out = setfield(out, idxNames{idx}, [0 0]);
    end
  else
    out = struct(tblName, tbl);
    for idx = 1:length(idxNames),
      out = setfield(out, idxNames{idx}, 0);
    end
  end
  return;
end

% special check: one index
if dimCount == 1,
  if sum(size(tbl)>1) > 1,
    error(['''' tblName ''' must be a vector if there is only one index vector defined.']);
  end
  % make sure tbl is a column vector
  tbl = tbl(:);
end

%
for idx = 1:length(idxNames),
  if (idxDim(idx)),
    if length(idxVec{idx}) ~= size(tbl, idx),
      error(['Length of ''' idxNames{idx} ''' must match dimension ' num2str(idxDim(idx)) ' of ''' tblName '''.']);
    end
  else
    shape = size(tbl);
    shape = [shape(1:idx-1) 1 shape(idx:end)];
    tbl = reshape(tbl, shape);
    idxVec{idx} = 0;
  end
  if length(idxVec{idx}) == 1 && expandIdx,
    idxVec{idx} = repmat(idxVec{idx}, 2, 1);
    shape = ones(1, max(2, idx));
    shape(idx) = 2;
    tbl = repmat(tbl, shape);
  end
end

out = struct(tblName, tbl);
for idx = 1:length(idxNames),
  out = setfield(out, idxNames{idx}, idxVec{idx});
end

% copy any further (non-index) fields from the input struct
otherFields = fieldnames(in);
for idx = 1:length(otherFields),
    out = setfield(out, otherFields{idx}, getfield(in, otherFields{idx}));
end

% end function
