#ifndef PLECSRTW_H_
#define PLECSRTW_H_

#include <stddef.h>

typedef struct {
   const size_t numX, numY, numZ, numW;
   const double x0, y0, z0, w0;
   const double dXInv, dYInv, dZInv, dWInv;
   const double *xVec, *yVec, *zVec, *wVec, *data;
} plecsLUT;

extern double plecsmod(double, double);

extern double plecslu1d(const plecsLUT*, double);
extern double plecslu1deven(const plecsLUT*, double);
extern double plecslu2d(const plecsLUT*, double, double);
extern double plecslu2deven(const plecsLUT*, double, double);
extern double plecslu3d(const plecsLUT*, double, double, double);
extern double plecslu3deven(const plecsLUT*, double, double, double);
extern double plecslu4d(const plecsLUT*, double, double, double, double);
extern double plecslu4deven(const plecsLUT*, double, double, double, double);

struct CScriptStruct
{
   int numInputTerminals;
   int numOutputTerminals;
   const int* numInputSignals;
   const int* numOutputSignals;
   int numContStates;
   int numDiscStates;
   int numZCSignals;
   int numSampleTimes;
   int numParameters;
   int isMajorTimeStep;
   int isRefineStep;
   double time;
   const double* const* const* inputs;
   double* const* const* outputs;
   double *contStates;
   double *contDerivs;
   double *discStates;
   double *zCSignals;
   const int *paramNumDims;
   const int* const* paramDims;
   const int *paramNumElements;
   const double* const* paramRealData;
   const char* const* paramStringData;
   const char * const *sampleHits;
   const double *sampleTimePeriods;
   const double *sampleTimeOffsets;
   const double* const *inputSampleTimePeriods;
   const double* const *inputSampleTimeOffsets;
   double *nextSampleHit;
   const char** errorStatus;
   const char** warningStatus;
   const char** rangeErrorMsg;
   int* rangeErrorLine;
   void* instruction;
   void (*writeCustomStateDouble)(void*, double);
   double (*readCustomStateDouble)(void*);
   void (*writeCustomStateInt)(void*, int);
   int (*readCustomStateInt)(void*);
   void (*writeCustomStateData)(void*, const void*, int);
   void (*readCustomStateData)(void*, void*, int);
};

struct FSM_Struct
{
   int fsm_isMajorTimeStep;
   double fsm_currentTime;
   const double *fsm_internalConstants;
   const double ***fsm_inputs;
   double ***fsm_outputs;
   double *fsm_discStates;
   double *fsm_zCSignals;
   int *fsm_takenTransitions;
   double *fsm_nextSampleHit;
   double fsm_samplingFrequency;
   const char **fsm_errorStatus;
   const char **fsm_warningStatus;
};

#endif
