local list = {}
--
local function fcn_vec_rotate(x,y)
  x,y = y,x
  for k,v in ipairs(x) do y[k] = y[k]*-1 end -- rotate counter clockwise
  --for k,v in ipairs(x) do x[k] = x[k]*-1 end --  clockwise
  return x,y
end
local function fcn_vec_flip(x,y)
  for k,v in ipairs(x) do x[k] = x[k]*-1 end
  return x,y
end
--
local function transf_vec_coord(x,y,rotate,flip)
	if rotate<0 then rotate = rotate +360 elseif rotate>360 then rotate = rotate-360 end
  for i = rotate/90, 1, -1 do
    x,y = fcn_vec_rotate(x,y)
  end
  if flip then
    x,y = fcn_vec_flip(x,y)
  end
  return x,y
end
--
function list.Resistor(x0,y0,params)
	if params == nil then params={} end
	x0 = x0 or 0
	y0 = y0 or 0 
	local rot = params.rot or 0
	local flip
	if params.flip == nil then flip = false else flip = params.flip end
	local L = params.len or 40
	local K = L/40
	--
	local x = {Vector{0,0,5,5,0,0,0,-5,-5,0}}
	local y = {Vector{-20,-15,-15,15,15,20,15,15,-15,-15}}
	local x,y = transf_vec_coord(x,y,rot,flip)
	for k,v in ipairs(x) do
		Icon:line(x0+x[k]*K,y0+y[k]*K)
	end
end
--
function list.Capacitor(x0,y0,params)
	if params == nil then params={} end
	x0 = x0 or 0
	y0 = y0 or 0 
	local rot = params.rot or 0
	local flip
	if params.flip == nil then flip = false else flip = params.flip end
	local L = params.len or 20
	local meas
	if params.meas == nil then meas = false else meas = params.meas end
	local K = L/20
	--
	local x = {Vector{0,0,8,-8,0},Vector{0,8,-8,0,0}}
	local y = {Vector{-10,-2,-2,-2,-2},Vector{2,2,2,2,10}}
	local x,y = transf_vec_coord(x,y,rot,flip)
	for k,v in ipairs(x) do
		Icon:line(x0+x[k]*K,y0+y[k]*K)
	end
	-- measurement decoration
	if meas then
		x = {Vector{4,8},Vector{6,6}}
		y = {Vector{-8,-8},Vector{-10,-6}}
		x,y = transf_vec_coord(x,y,rot,flip)
		for k,v in ipairs(x) do
		Icon:line(x0+x[k]*K,y0+y[k]*K)
		end
	end
end
--
function list.Diode(x0,y0,params)
	if params == nil then params={} end
	x0 = x0 or 0
	y0 = y0 or 0 
	local rot = params.rot or 0
	local flip
	if params.flip == nil then flip = false else flip = params.flip end
	local L = params.len or 30
	local K = L/30
	--
	local x = {Vector{0,0,-7,7,0,7,0,0,0,-7,0}}
	local ter = 5;
	if params.ter ~= nil then
	   ter = params.ter
    end
	local y = {Vector{-10-ter,-6,-6,-6,-6,6,6,10+ter,6,6,-6}}
	local x,y = transf_vec_coord(x,y,rot,flip)
	for k,v in ipairs(x) do
		Icon:line(x0+x[k]*K,y0+y[k]*K)
	end
end
--
function list.Thyristor(x0,y0,params)
	if params == nil then params={} end
	x0 = x0 or 0
	y0 = y0 or 0 
	local rot = params.rot or 0
	local flip
	if params.flip == nil then flip = false else flip = params.flip end
	local L = params.len or 30
	local K = L/30
	--
	local x = {Vector{0,0,-7,7,0,7,0,0,0,-7,0},Vector{0,-4,-7,-15}}
	local y = {Vector{-15,-6,-6,-6,-6,6,6,15,6,6,-6},Vector{-6,-6,-10,-10}}
	local x,y = transf_vec_coord(x,y,rot,flip)
	for k,v in ipairs(x) do
		Icon:line(x0+x[k]*K,y0+y[k]*K)
	end
end
--
function list.IGBT(x0,y0,params)
	if params == nil then params={} end
	x0 = x0 or 0
	y0 = y0 or 0 
	local rot = params.rot or 0
	local flip
	if params.flip == nil then flip = false else flip = params.flip end
	local L = params.len or 40
	local K = L/40
	--
	local x = {Vector{0,0,-10,-10,0,0},Vector{-10,-10},Vector{-14,-14},Vector{-14,-20},Vector{-5.65, -1.667, -3.864}}
	local y = {Vector{-20,-10,-4,4,10,20},Vector{-8,8},Vector{-8,8},Vector{0,0},Vector{8.634, 9, 5.658}}
	x,y = transf_vec_coord(x,y,rot,flip)
	for k,v in ipairs(x) do
		Icon:line(x0+x[k]*K,y0+y[k]*K)
	end
end
--
function list.IGBTD(x0,y0,params)
	if params == nil then params={} end
	x0 = x0 or 0
	y0 = y0 or 0  
	local rot = params.rot or 0
	local flip
	if params.flip == nil then flip = false else flip = params.flip end
	local L = params.len or 40
	local K = L/40
	-- IGBT from library
	list.IGBT(x0,y0,{rot=rot,flip=flip,len=40*K})
	-- Diode from library
	-- Rotation of Diode coordinates
	local xD = {Vector{10}}
	local yD = {Vector{0}}
	xD, yD = transf_vec_coord(xD,yD,rot,flip)
	list.Diode(x0+xD[1][1]*K, y0+yD[1][1]*K, {rot=rot,flip=flip,len=30*K,ter=4})
	-- IGBT/Diode connections
	local x = {Vector{0,10},Vector{0,10}}
	local y = {Vector{-14,-14},Vector{14,14}}
	x, y = transf_vec_coord(x,y,rot,flip)
	for k,v in ipairs(x) do
		Icon:line(x0+x[k]*K,y0+y[k]*K)
	end
end
--
function list.MOSFET(x0,y0,params)
	if params == nil then params={} end
	x0 = x0 or 0
	y0 = y0 or 0 
	local rot = params.rot or 0
	local flip
	if params.flip == nil then flip = false else flip = params.flip end
	local L = params.len or 40
	--
	local x = {Vector{0,0,-10},Vector{-10,-10},Vector{-10,-10},Vector{-10,-10},Vector{-10,0,0,-10,0,0},Vector{-15,-15},Vector{-15,-20},Vector{-4,-8,-4}}
	local y = {Vector{-20,-10,-10},Vector{-13,-7},Vector{-3,3},Vector{7,13},Vector{0,0,10,10,10,20},Vector{-10,10},Vector{0,0},Vector{-2,0,2}}
	local K = L/40
	x,y = transf_vec_coord(x,y,rot,flip)
	for k,v in ipairs(x) do
		Icon:line(x0+x[k]*K,y0+y[k]*K)
	end
end
--
function list.MOSFETD(x0,y0,params)
	if params == nil then params={} end
	x0 = x0 or 0
	y0 = y0 or 0 
	local rot = params.rot or 0
	local flip
	if params.flip == nil then flip = false else flip = params.flip end
	local L = params.len or 40
	local K = L/40
	-- MOSFET from library
	list.MOSFET(x0, y0, {rot=rot, flip=flip, len=40*K})
	-- Diode from library
	-- Rotation of Diode coordinates
	local xD = {Vector{12}}
	local yD = {Vector{0}}
	xD, yD = transf_vec_coord(xD,yD,rot,flip)
	list.Diode(x0+xD[1][1]*K, y0+yD[1][1]*K, {rot=rot, flip=flip, len=30*K, ter=4})
	-- MOSFET/Diode connections
	local x = {Vector{0,12},Vector{0,12}}
	local y = {Vector{-14,-14},Vector{14,14}}
	x, y = transf_vec_coord(x,y,rot,flip)
	for k,v in ipairs(x) do
		Icon:line(x0+x[k]*K,y0+y[k]*K)
	end
end
--
function list.Inductor(x0,y0,params)
	if params == nil then params={} end
	x0 = x0 or 0
	y0 = y0 or 0 
	local rot = params.rot or 0
	local flip
	if params.flip == nil then flip = false else flip = params.flip end
	local meas, ter
	if params.meas == nil then meas = false else meas = params.meas end
	if params.ter == nil then ter = true else ter = params.ter end
	local K,L,x,y
	if rot>360 then rot=rot-360 elseif rot<0 then rot=rot+360 end
	if ter then
		L = params.len or 40
		K = L/40
		local x = {Vector{-20,-14},Vector{14,20}}
		local y = {Vector{0,0},Vector{0,0}}
		x,y = transf_vec_coord(x,y,rot,flip)
		for k,v in ipairs(x) do
			Icon:line(x0+x[k]*K,y0+y[k]*K)
		end
	else
		L = params.len or 28
		K = L/28
	end
	x = {Vector{14,14}}
	y = {Vector{0,-1}}
	x,y = transf_vec_coord(x,y,rot,flip)
	for k,v in ipairs(x) do
		Icon:line(x0+x[k]*K,y0+y[k]*K)
	end
	-- draw arcs
	local x_arc, y_arc, rx, ry, start, span = 0, 0, 3.5*K, 3.5*K, 180+rot, -180
	if start>360 then start=start-360 elseif start<0 then start=start+360 end
	if flip and (rot == 90 or rot ==270) then span = -span end
	local x_line, y_line = 0, 0
	for deltaX = -10.5*K, 10.5*K, 7*K do
		--x_arc = deltaX
		--y_arc = -1.5*K
		--for i = rot/90, 1, -1 do x_arc,y_arc = -y_arc,x_arc end
		--if flip then x_arc,y_arc = -x_arc,y_arc end
		x_arc = {Vector{deltaX}}
		y_arc = {Vector{-1.5*K}}
		x_arc,y_arc = transf_vec_coord(x_arc,y_arc,rot,flip)
		for k,v in ipairs(x) do
			Icon:arc(x_arc[k][1]+x0, y_arc[k][1]+y0, rx, ry, start, span)
		end
		x_line, y_line = {Vector{deltaX, deltaX}-rx}, {Vector{0, -1.5*K}}
		x_line, y_line = transf_vec_coord(x_line,y_line,rot,flip)
		Icon:line(x_line[1]+x0,y_line[1]+y0)
	end
	-- measurements decorations
	if meas then
		x = {Vector{16,20,16}}
		y = {Vector{-2,0,2}}
		x,y = transf_vec_coord(x,y,rot,flip)
		for k,v in ipairs(x) do
			Icon:line(x0+x[k]*K,y0+y[k]*K)
		end
	end
end
--
function list.Winding(x0,y0,params)
	if params == nil then 
		params={} 
	end
	params.meas = false
	list.Inductor(x0,y0,params)
end
--
function list.Transformer(x0,y0,params)
	if params == nil then params={} end
	x0 = x0 or 0
	y0 = y0 or 0 
	local rot = params.rot or 0
	local flip
	if params.flip == nil then flip = false else flip = params.flip end
	local core, L, K
	if params.core == nil then core = false else core = params.core end
	if params.ter == nil then ter = false else ter = params.ter end
	if ter then
		L = params.len or 40
		K = L/40
	else 
		L = params.len or 30
		K = L/30
	end
	-- Primary winding
	local x_shift = {Vector{-10}}
	local y_shift = {Vector{0}}
	x_shift, y_shift = transf_vec_coord(x_shift,y_shift,rot,flip)
	list.Winding(x0+x_shift[1][1]*K, y0+y_shift[1][1]*K, {rot=rot+270, flip=flip, len=L, ter=ter})
	-- Secondary winding
	x_shift = {Vector{10}}
	y_shift = {Vector{0}}
	x_shift, y_shift = transf_vec_coord(x_shift,y_shift,rot,flip)
	list.Winding(x0+x_shift[1][1]*K, y0+y_shift[1][1]*K,{rot=rot+90, flip=flip, len=L, ter=ter})
	-- magnetic core decoration
	if core then
		local x = {Vector{-1.5,-1.5},Vector{1.5,1.5}}
		local y = {Vector{-15,15},Vector{-15,15}}
		x,y = transf_vec_coord(x,y,rot,flip)
		Icon:color("electrical")
		for k,v in ipairs(x) do
			Icon:line(x0+x[k]*K,y0+y[k]*K)
		end
		Icon:color("electrical")
	end
end
--
function list.Node(x0,y0,params)
	if params == nil then params={} end
	x0 = x0 or 0
	y0 = y0 or 0 
	local L = params.len or 1
	Icon:circle(x0,y0,L)
end
--
return list