## Copyright (C) 2010, 2011 Plexim GmbH. All rights reserved.
## 
## This file is part of PLECS
##
## -*- texinfo -*-
## Command: doc FUNCTION_NAME
##
## Display documentation for the function FUNCTION_NAME
## from the Octave documentation.
## If invoked without any arguments, the Octave manual is shown from the beginning.
##
## For example, the command `doc sin' shows the documentation for
## the sin function.

function doc(varargin)
   if (nargin > 1)
      error('Usage: doc FUNCTION_NAME');
   end
   try
      if (nargin == 1)
         plecs('doc', varargin{1});
      else
         plecs('doc', '');
      end
   catch
      disp(lasterr);
   end_try_catch
end
