function v = plVectorize(vToCheck, vToMatch, opt_fixedLen)
    % vectorizeData(vToCheck, vToMatch)
    %
    % The input data 'vToCheck' is vectorized to match the length of 'vToMatch'.
    % 
    %   returns the scaled vector, or 
    %   logs an error and returns empty array if this scaling is not possible.
    % 
    % Note vectorize() must be called with argument names that match the 
    % the Block.Mask.Parameter names. Links are generated based on the variable
    % names at the call site. Example usage: Scale = vectorize(Scale, Adcs),
    % which will generate links to the Block.Mask.Scale and Block.Mask.Adcs
    % widgets.

    % In the case of the optional arg: opt_fixedLen, if provided, this will
    % be the length used, and the second arg is ignored.

    checkLink = ['The parameter @param:' inputname(1) ':'];

    if nargin == 3
        % use the fixed length and ignore the second arg
        desiredLen = opt_fixedLen;
        matchText = ['length ' num2str(desiredLen)];
    else
        % generate a link and use the specified vector to determine the length
        desiredLen = length(vToMatch);
        matchText = ['the same length as the parameter @param:' inputname(2) ':' ...
                     '. The expected length was ' num2str(desiredLen)];        
    end

    if length(vToCheck) == desiredLen
        % no changes needed
        v = vToCheck;
        return;
    end

    if length(vToCheck) ~= 1
        % If the length did not match above we will pad it below,
        % however, check value length should be 1 in this case.
        plecs('error',[checkLink ' must be a scalar or a vector of ' matchText '.']); 
        v = [];
        return;
    end

    % return the padded vector
    v = vToCheck * ones(1, desiredLen);
end
