import xmlrpc.client
import os
import numpy as np
from rainflow_lib import rainflow_count, cycle_histogram, predict_lifetime
import matplotlib.pyplot as plt
plt.close('all')

MODEL_NAME = "rainflow_counting"
server = xmlrpc.client.Server("http://localhost:1080/RPC2")
server.plecs.load(os.path.join(os.getcwd(),'../', MODEL_NAME))

Load_profile = 2 # Choice of load profile: 1 = constant, 2 = load torque variation
Tsim = 8.0 # Simulation time span
Tres = 1e-3 # Time resolution of returned simulations results
Nf_a = 4.97e13 # Lifetime parameter a
Nf_b = 4.61 # Lifetime parameter b
plots = 'yes' # plecsblue = [0 164 227]/255; plecsred = [233 61 69]/255; # Show plots (yes/no), define colors
Load_torque_freq = 0.2 # Frequency of the load torque variation

if (Load_profile == 1):
   time_window = 0.1 # Analyze only the last 10% in steady-state
else:
   time_window = 1.0/Tsim/Load_torque_freq # Analyze only the last periodic load cycle

# Set up model variables and solver options for PLECS simulation
OptStruct = {
'ModelVars': {'Tsim': Tsim,'Load_profile': Load_profile,'Load_torque_freq': Load_torque_freq},
'SolverOpts': {'OutputTimes': np.arange((1.-time_window)*Tsim,Tsim,Tres).tolist()}
}

results = server.plecs.simulate(MODEL_NAME, OptStruct)
server.plecs.close(MODEL_NAME)

idcs = np.diff(np.sign(np.diff(results['Values']))).nonzero()[1]+1

Tj_ex = [results['Values'][0][i] for i in idcs]
t_ex = [results['Time'][i] for i in idcs]

# Tj_extreme_filename = extract_extreme_Tj(results['Values'],results['Time'])

# print ('Extreme Tj points have been extracted from Tj waveform!')

# count Tj cycles using rainflow counting algorithm
# input: Tj_extreme_filename - returned csv filename (string) from extract_extreme_Tj()
# return: cyc_ampl, cyc_freq - amplitudes and frequencies (list) of Tj cycles
cyc_ampl, cyc_freq = rainflow_count(t_ex,Tj_ex)
print ('Tj cycles have been counted!')

# generate histogram of Tj cycles
# input: cyc_ampl, cyc_freq - rainflow_count() returns
#        bin_width - the width of bin
# return: hist_bin, hist_cycle_number - histogram bins, number of cycles (list)  
bin_width = 5
hist_bin, hist_cycle_number = cycle_histogram(cyc_ampl, cyc_freq, bin_width)
print ('Histogram of Tj cycles has been generated!')

# time period of load cycle
t_period = Tsim*time_window
# lifetime model parameters
# Nf = Nf_a*(delta Tj)^(-Nf_b)
Nf_a = 4.97e13
Nf_b = 4.61
# predict lifetime
# input: Nf_a, Nf_b - lifetime model parameters
#        hist_bin, hist_cycle_number - cycle_histogram() returns
#        t_period - time period of load
# return: lifetime in years
lifetime_year = predict_lifetime(Nf_a, Nf_b, hist_bin, hist_cycle_number, t_period)
print ('Lifetime of IGBT module has been calculated! It is %s year(s)' % (lifetime_year))

plt.show()
