## Copyright (C) 2010-2024 Plexim GmbH. All rights reserved.
##
## This file is part of PLECS

function wsout = pleval(wsin, expr, isCommandList)

try
    if (isCommandList)
        iPrepareAndEvalCommands(wsin, expr);
        wsout = iCollectWorkspace();
    else
        wsout = iPrepareAndEvalExpression(wsin, expr);
    end
catch
    if (exist('rethrow')~=5)
        error(lasterr)
    else
        rethrow(lasterror)
    end
end



function iPrepareAndEvalCommands(wsin, expr)

% first of all, make a clean slate in the caller workspace
evalin('caller', 'clear');

% next, assign the ws-variables passed via the wsin-struct
vars = fieldnames(wsin);
for idx = 1:length(vars)
    assignin('caller', vars{idx}, getfield(wsin, vars{idx}));
end

% now evaluate the expression
try
    evalin('caller', expr);
catch
    errMsg = lasterr;
    if (length(expr) > 8192) % workaround for octave bug with scritps longer than 8192 characters
        try
            eval('who'); % dummy command, will result in another error
        catch
        end
    end
    error(errMsg);
end



function xwsout = iCollectWorkspace

% accumulate the xwsout-struct
xwsout = struct();
vars = evalin('caller', 'who');
for idx = 1:length(vars)
    try
        if ~strcmp(vars{idx}, 'wsout'),
            value = evalin('caller', vars{idx});
            if ~is_function_handle(value)
                xwsout.(vars{idx}) = value;
            end
        end
    catch
    end
end



function xwsout = iPrepareAndEvalExpression(wsin, expr)

% first of all, make a clean slate in the caller workspace
evalin('caller', 'clear');

% next, assign the ws-variables passed via the wsin-struct
vars = fieldnames(wsin);
for idx = 1:length(vars)
    assignin('caller', vars{idx}, getfield(wsin, vars{idx}));
end

xwsout = evalin('caller', expr);
