/*
   Copyright (c) 2016 by Plexim GmbH
   All rights reserved.

   A free license is granted to anyone to use this software for any legal
   non safety-critical purpose, including commercial applications, provided
   that:
   1) IT IS NOT USED TO DIRECTLY OR INDIRECTLY COMPETE WITH PLEXIM, and
   2) THIS COPYRIGHT NOTICE IS PRESERVED in its entirety.

   THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
   OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
   FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
   AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
   LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
   OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
   SOFTWARE.
 */

#ifndef ANALOGOUT_H_
#define ANALOGOUT_H_

#include "plexim/hw_wrapper.h"

#define DAC_INDEX0 17
#define DAC_INDEX1 0
#define DAC_INDEX2 20
#define DAC_INDEX3 1
#define DAC_INDEX4 21
#define DAC_INDEX5 4
#define DAC_INDEX6 24
#define DAC_INDEX7 5
#define DAC_INDEX8 25
#define DAC_INDEX9 8
#define DAC_INDEX10 28
#define DAC_INDEX11 9
#define DAC_INDEX12 29
#define DAC_INDEX13 12
#define DAC_INDEX14 32
#define DAC_INDEX15 13
#define DAC_INDEX16 19
#define DAC_INDEX17 2
#define DAC_INDEX18 22
#define DAC_INDEX19 3
#define DAC_INDEX20 23
#define DAC_INDEX21 6
#define DAC_INDEX22 26
#define DAC_INDEX23 7
#define DAC_INDEX24 27
#define DAC_INDEX25 10
#define DAC_INDEX26 30
#define DAC_INDEX27 11
#define DAC_INDEX28 31
#define DAC_INDEX29 14
#define DAC_INDEX30 34
#define DAC_INDEX31 15

#define DAC_SETUP_INDEX0 9
#define DAC_SETUP_INDEX1 0
#define DAC_SETUP_INDEX2 10
#define DAC_SETUP_INDEX3 1
#define DAC_SETUP_INDEX4 11
#define DAC_SETUP_INDEX5 2
#define DAC_SETUP_INDEX6 12
#define DAC_SETUP_INDEX7 3
#define DAC_SETUP_INDEX8 13
#define DAC_SETUP_INDEX9 4
#define DAC_SETUP_INDEX10 14
#define DAC_SETUP_INDEX11 5
#define DAC_SETUP_INDEX12 15
#define DAC_SETUP_INDEX13 6
#define DAC_SETUP_INDEX14 16
#define DAC_SETUP_INDEX15 7
#define DAC_SETUP_INDEX16 (9 | 0x40)
#define DAC_SETUP_INDEX17 (0 | 0x40)
#define DAC_SETUP_INDEX18 (10 | 0x40)
#define DAC_SETUP_INDEX19 (1 | 0x40)
#define DAC_SETUP_INDEX20 (11 | 0x40)
#define DAC_SETUP_INDEX21 (2 | 0x40)
#define DAC_SETUP_INDEX22 (12 | 0x40)
#define DAC_SETUP_INDEX23 (3 | 0x40)
#define DAC_SETUP_INDEX24 (13 | 0x40)
#define DAC_SETUP_INDEX25 (4 | 0x40)
#define DAC_SETUP_INDEX26 (14 | 0x40)
#define DAC_SETUP_INDEX27 (5 | 0x40)
#define DAC_SETUP_INDEX28 (15 | 0x40)
#define DAC_SETUP_INDEX29 (6 | 0x40)
#define DAC_SETUP_INDEX30 (16 | 0x40)
#define DAC_SETUP_INDEX31 (7 | 0x40)

#define DAC_METER_INDEX0 16
#define DAC_METER_INDEX1 0
#define DAC_METER_INDEX2 18
#define DAC_METER_INDEX3 1
#define DAC_METER_INDEX4 19
#define DAC_METER_INDEX5 4
#define DAC_METER_INDEX6 22
#define DAC_METER_INDEX7 5
#define DAC_METER_INDEX8 23
#define DAC_METER_INDEX9 8
#define DAC_METER_INDEX10 26
#define DAC_METER_INDEX11 9
#define DAC_METER_INDEX12 27
#define DAC_METER_INDEX13 12
#define DAC_METER_INDEX14 30
#define DAC_METER_INDEX15 13
#define DAC_METER_INDEX16 17
#define DAC_METER_INDEX17 2
#define DAC_METER_INDEX18 20
#define DAC_METER_INDEX19 3
#define DAC_METER_INDEX20 21
#define DAC_METER_INDEX21 6
#define DAC_METER_INDEX22 24
#define DAC_METER_INDEX23 7
#define DAC_METER_INDEX24 25
#define DAC_METER_INDEX25 10
#define DAC_METER_INDEX26 28
#define DAC_METER_INDEX27 11
#define DAC_METER_INDEX28 29
#define DAC_METER_INDEX29 14
#define DAC_METER_INDEX30 31
#define DAC_METER_INDEX31 15



/// Defining the hardware limits of all analog outputs.
typedef enum
{
   M00P50,///< 0V up to 5V.
   M00P100,///< 0V up to 10V.
   M50P50,///< -5V up to 5V.
   M100P100,///< -10V up to 10V.
   M25P25,///< -2.5V up to 2.5V.
   M25P75///< -2.5V up to 7.5V.
} DACSpan;

#define inf MAXFLOAT

/**
* @brief Setup of the n-th analog output.
 * 
 *	
 * @param n ID of analog input.
 * @param scale Scaling factor.
 * @param offset Offset.
 * @param min Minimum value to the DAC.
 * @param max Maximum value to the DAC.
 */
 
#define setupAnalogOut(aChannel, aScale, aOffset, aMin, aMax)  \
   _plxSetupAnalogOut(DAC_INDEX##aChannel, DAC_SETUP_INDEX##aChannel, aScale, aOffset, aMin, aMax)
 
void _plxSetupAnalogOut(int aChannel, int aSetupChannel, float aScale, float aOffset, float aMin, float aMax);

/**
* @brief Defines the voltage at the n-th analog output.
 * 
 *	
 * @param n ID of analog output.
 * @param x Voltage at analog output.
 */   

#define setAnalogOut(aChannel, aValue)  *(plxIo.DACOutput+DAC_INDEX##aChannel) = aValue

/**
* @brief Global setup for DAC modules.
 * 
 *	
 * @param aSpan DAC output span.
 */ 
int plxSetupDACs(DACSpan aSpan);

/**
 * @brief Enable/Disable DAC outputs.
 * DAC outputs are disabled by default.  
 *
 * @param aValue Outputs are disabled when set to FALSE, enabled when set to TRUE.
 */ 
void plxEnableAnalogOutputs(PLX_BOOL aValue);

void _plxSetupMeterOutput(uint16_t aChannel, uint16_t aMeterIndex);

#define plxSetupMeterOutput(aChannel, aMeterIndex) _plxSetupMeterOutput(DAC_METER_INDEX##aChannel, aMeterIndex)

int plxGetDacSpan(void);

int plxGetNumFastDACs(void);

#endif

