/*
   Copyright (c) 2018 by Plexim GmbH
   All rights reserved.

   A free license is granted to anyone to use this software for any legal
   non safety-critical purpose, including commercial applications, provided
   that:
   1) IT IS NOT USED TO DIRECTLY OR INDIRECTLY COMPETE WITH PLEXIM, and
   2) THIS COPYRIGHT NOTICE IS PRESERVED in its entirety.

   THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
   OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
   FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
   AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
   LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
   OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
   SOFTWARE.
 */
#ifndef CAN_H_
#define CAN_H_

#include <stdint.h>

#pragma pack(push, 4)
   struct CanRequestIdMsg {
      uint32_t mMsg;
      uint32_t mMsgLength;
      uint8_t  mModuleId;
      uint32_t mNumCanIds;
      uint32_t mCanIds[1]; // placeholder dummy array of length 1
   };
#pragma pack(pop)

#include "plexim/HIL_Framework.h"

#ifdef __cplusplus
extern "C"
{
#endif

void setupCan(unsigned char aModule,
              unsigned int aBaudrate,
              unsigned int aTermination,
              unsigned int aRecoveryTimeout);
int canSendMessage(unsigned char aModule, unsigned int aId, unsigned int length, const unsigned char* data);
void plxRegisterCanRxIds(unsigned char aModule, struct CanRequestIdMsg* aRequestMsg, unsigned char** aBuffers, int** aIdzs);
void plxHandleCanMessage(const struct CanReceiveMsg* aMsg);

void plxSendQueuedCanMessages();

#ifdef __cplusplus
}
#endif

#endif
