#ifndef PHYSICALMODEL_H
#define PHYSICALMODEL_H

#include <stdint.h>
#include "plexim/hw_wrapper.h"

#ifdef __cplusplus
extern "C"
{
#endif

#define PM_DISCRETIZATION_METHOD_TUSTIN 0
#define PM_DISCRETIZATION_METHOD_RADAU  1

#define PM_DCS_CONDSTATE_OPEN  0
#define PM_DCS_CONDSTATE_UPPER 1
#define PM_DCS_CONDSTATE_LOWER 2

struct FPGAPhysicalModelMatrix
{
   const int* rowptr;
   const int* colidx;
   const double* data;
};

struct FPGAPhysicalModel
{
   int nx;
   int nu;
   int ny;
   int ndcs;
   int nuhb;
   int ny_ext;
   const int* y_ext_indices;

   const struct FPGAPhysicalModelMatrix* mat_A;
   const struct FPGAPhysicalModelMatrix* mat_B;
   const struct FPGAPhysicalModelMatrix* mat_C;
   const struct FPGAPhysicalModelMatrix* mat_D;
   const struct FPGAPhysicalModelMatrix* mat_I;
   
   int discretization_method;

   const float* x_init;
   const int* s_init;

   struct
   {
      double resistance;

      const int* u_indices;
      const int* y_indices;

      const int* gated_turn_on;
      const int* gated_turn_off;

      const double* upper_voltage_init;
      const double* lower_voltage_init;

      const int* upper_gate_init;
      const int* lower_gate_init;
      const int* upper_gate_write_enable;
      const int* lower_gate_write_enable;
      int all_gates_constant;

      const double* resonator_freq;
   } dcs;

   struct
   {
      const int* dcs_indices;
      const int* widths;

      const int* voltmeters;
      const int* current_sources;
      const int* upper_pwms;
      const int* lower_pwms;
      const int* upper_bias;
      const int* lower_bias;
   } uhb;

   double cpu_base_period;
   int sync_steps;
};

int FPGAPhysicalModel_getMaxSteps(double aCpuBasePeriod);
void FPGAPhysicalModel_setTrigger(uint32_t aStepTicks, uint32_t aStartTick, int aSyncSteps, int aFraction);

void FPGAPhysicalModel_setup(const struct FPGAPhysicalModel* aModel);

extern float FPGAPhysicalModel_outputScaleFactor;
#define FPGAPhysicalModel_getOutput(i) \
      (*(plxIo.PhysicalModelOutputStateSpace + i) * FPGAPhysicalModel_outputScaleFactor)

int FPGAPhysicalModel_getConductionState(int i);

#define FPGAPhysicalModel_setInput(i, u) \
   *(plxIo.PhysicalModelInputStateSpace + i) = u


void FPGAPhysicalModel_setDcsUpperGate(int i, int g_up);
void FPGAPhysicalModel_setDcsLowerGate(int i, int g_lo);

void FPGAPhysicalModel_setupOutputToNanostep(uint32_t aNanostepIndex, uint32_t aMeterIdx1, uint32_t aMeterIdx2);
void FPGAPhysicalModel_setupInputFromNanostep(uint32_t aNanostepIndex, uint32_t aNanostepMeterIndex, uint32_t aInputIdx);

#ifdef __cplusplus
}
#endif

#endif // PHYSICALMODEL_H
