/*
 * hw_wrapper.h
 *
 *  Created on: Dec 23, 2014
 *      Author: Oliver
 */

#ifndef HW_WRAPPER_H_
#define HW_WRAPPER_H_

#include <stdint.h>

#ifdef __cplusplus
extern "C"
{
#endif

typedef int PLX_BOOL;

#ifndef FALSE
#define FALSE 0
#endif

#ifndef TRUE
#define TRUE 1
#endif

typedef enum
{
   PLX_SUCCESS,
   PLX_FAILURE
} PlxStatus;

typedef enum
{
   VOUT_3V3,
   VOUT_5V0
} DigitalOutVoltage;

typedef enum
{
   PWM_NEGATIVE_POLARITY,
   PWM_POSITIVE_POLARITY
} PWMPolarity;

typedef enum {
   PLXUSERMSG_NEEDS_ATTENTION = 0x1,
   PLXUSERMSG_CLOSE_MESSAGE_WINDOW = 0x02
} PlxUserMessageFlags;

typedef uint32_t u32;
typedef int32_t s32;
typedef int16_t s16;
typedef uint16_t u16;
typedef uint8_t u8;

typedef struct {
   float* DACOutput;
   uint32_t* PWMTrigger;
   uint16_t* PWMOutput;
   uint32_t* ENCOutput;
   uint8_t* SPIEnable;
   uint16_t* PowerstageReset;
   uint32_t* EndatPosition;
   float* SFPOutput;
   uint16_t* SPIOutput0;
   uint16_t* SPIOutput1;
   char* PhysicalModelInput;
   float* PhysicalModelInputStateSpace;
   float* NanostepVoltageOutput;

   float* SFPInput;
   uint16_t* SPIInputState;
   uint16_t* SPIInput0;
   uint16_t* SPIInput1;
   char* PhysicalModelOutput;
   float* PhysicalModelOutputStateSpace;
   uint32_t* DiffEncInput;
   uint16_t* ActiveCountPWM;
   uint64_t* Assertions;
   uint64_t* DigitalInput;
   uint8_t* PWMFallingEdges;
   float* ADCInput;
   uint16_t* RslvInput;
   uint8_t* PowerstageState;
   float* PWMCycleRate;
   float* NanostepCurrentInput;
   float* NanostepILVCInput;
   uint8_t* any_overflow;
} PlxIo;

extern PlxIo plxIo;
extern float plxPWMCycleRate;

int postInitCode(void);
void plxSetDigitalOutVoltage(DigitalOutVoltage aValue);
DigitalOutVoltage plxGetDigitalOutVoltage(void);
void plxSetupAnalogSampling(u32 aMode, u32 aTicks, double aStepSize);
uint32_t plxGetCpuFreq();
void plxResetPeripherals();
void plxStopTimer();
void printk(const char *ctrl1, ...);
void plxPrintf(const char * aFormat, ...);
void plxUserMessage(int aFlags, const char * aFormat, ...);
int postInitCode();
void plxSetBufferAdresses();
void plxUpdatePWMCycleRate();

#define plxWaitForIrqAck()

#ifdef __cplusplus
}
#endif

#endif /* HW_WRAPPER_H_ */
