local Module = {}

local static = {
  instances = {}
}

function Module.getBlock(globals)
  local PWMCapture = require('blocks.block').getBlock(globals)

  function PWMCapture:getDirectFeedthroughCode()
    local include = StringList:new()
    local initCode = StringList:new()
    local outputCode = StringList:new()
    local outputMetaData = {}
    local require = ResourceList:new()
    local modelSampleTime = Target.Variables.SAMPLE_TIME
    local blockSampleTime = Block.NativeTask.SampleTime[1]

    include:append("plexim/DigitalIn.h");

    local outputSignal = Block:OutputSignal()

    for idx = 1, Block.NumOutputSignals[1] do
      local channel = Block.Mask.channel[idx]
      local polarity = Block.Mask.polarity[idx]
      local inputType = Block.Mask.inputType[idx]
  
      require:add("Digital input", channel);
      initCode:append("plxSetupPWMCaptureChannel(%i, %i, %i);\n" % { channel, polarity, inputType })
    end

    local bufferLength = math.floor(blockSampleTime/modelSampleTime + 0.5) - 1;

    local bufferIdx = Block:AddWorkVariable("size_t")
    initCode:append("%s = 0;\n" % { bufferIdx })
    local firstRun = Block:AddWorkVariable("int")
    initCode:append("%s = 1;\n" % { firstRun })

    for idx = 1, Block.NumOutputSignals[1] do
      local channel = Block.Mask.channel[idx]
      -- initial opening brace
      outputCode:append("{")

      outputCode:append("float* result = &%s;\n" % { outputSignal[1][idx] })
      if bufferLength > 0 then
        local buffer = Block:AddWorkVariable("float", bufferLength)

        initCode:append("memset(&%s, 0, %i*sizeof(float));\n" % { buffer[1], bufferLength })
        outputCode:append("float* buffer = &%s;\n" % { buffer[1] })
        -- calculate output  
        outputCode:append([=[
          /* average output of PWM capture */
          float duty = plxGetDigitalInAveraged(%(channel)i);
          if (%(firstRun)s == 0)
          {
             *result = duty;
             for (size_t i = 0; i < %(length)i; ++i)
                *result += buffer[i];
             *result *= 1.0/(%(length)i+1);
          }
          else
          {
             *result = duty;
          }
          /* buffer input signals */
          buffer[%(bufferIdx)s] = duty;
        ]=]
        %
        {
          channel = channel,
          firstRun = firstRun,
          width = bufferWidth,
          length = bufferLength,
          bufferIdx = bufferIdx,
        })

      else
        outputCode:append("*result = plxGetDigitalInAveraged(%i);\n" % { channel })
      end
      -- final closing brace
      outputCode:append("}\n")
    end -- for
    
    if bufferLength > 0 then
      outputCode:append("%(firstRun)s = 0;\n" % { firstRun = firstRun })
      -- increment buffer index
      outputCode:append("%(bufferIdx)s = (%(bufferIdx)s+1) %% %(length)i;\n" % { bufferIdx = bufferIdx, length = bufferLength })
    end
    
    outputMetaData[1] = {}
    for idx = 1, Block.NumOutputSignals[1] do
      local channel = Block.Mask.channel[idx]
      local polarity = Block.Mask.polarity[idx]
      outputMetaData[1][idx] = {}
      outputMetaData[1][idx]['port'] = "%i" % { channel }
      outputMetaData[1][idx]['polarity'] = "%i" % { polarity }
      outputMetaData[1][idx]['sourceType'] = "PWMCapture"
    end

    return {
      Include = include,
      Require = require,
      InitCode = initCode,
      OutputCode = outputCode,
      OutputMetaData = outputMetaData,
    }
  end
  
  return PWMCapture
end  
return Module