local PwmPreprocReg = {}

local Operations = {
  UNUSED = 0,
  DIRECT = 1,
  AND2 = 2,
  OR2 = 3,
  AND3 = 4
}

local NumChannels = 64

local function createEntry(aSel0, aRegistry)
  entry = {}
  entry.sel0 = aSel0
  entry.sel1 = 0
  entry.sel2 = 0
  entry.pol0 = 1
  entry.pol1 = 1
  entry.pol2 = 1
  entry.opCapture = Operations.UNUSED
  entry.opAssertion = Operations.UNUSED
  table.insert(aRegistry, entry)
end


function PwmPreprocReg:new()
  local o = { 
    preprocRegistry = {}, 
    Result = {
      REDUNDANT = -1,
      NO_RESOURCE = -2
    }
  }
  for i = 0, NumChannels-1 do
    createEntry(i, o.preprocRegistry)
  end
  self.__index = self
  setmetatable(o, self)
  return o
end


function PwmPreprocReg:getPreprocForAnd2Capture(aCh1, aPol1, aCh2, aPol2)
  local entry1 = self.preprocRegistry[aCh1+1]
  local entry2 = self.preprocRegistry[aCh2+1]
  if entry1.opCapture == Operations.AND2 and entry1.sel1 == aCh2 then
    return aCh1
  elseif entry2.opCapture == Operations.AND2 and entry2.sel1 == aCh1 then
    return aCh2
  elseif entry1.opCapture == Operations.UNUSED then
    entry1.opCapture = Operations.AND2
    entry1.pol0 = aPol1
    entry1.sel1 = aCh2
    entry1.pol1 = aPol2
    return aCh1
  elseif entry2.opCapture == Operations.UNUSED then
    entry2.opCapture = Operations.AND2
    entry2.pol0 = aPol2
    entry2.sel1 = aCh1
    entry2.pol1 = aPol1
    return aCh2
  else
    return self.Result.NO_RESOURCE
  end
end


function PwmPreprocReg:getPreprocForOr2Capture(aCh1, aPol1, aCh2, aPol2)
  local entry1 = self.preprocRegistry[aCh1+1]
  local entry2 = self.preprocRegistry[aCh2+1]
  if entry1.opCapture == Operations.OR2 and entry1.sel1 == aCh2 then
    return aCh1
  elseif entry2.opCapture == Operations.OR2 and entry2.sel1 == aCh1 then
    return aCh2
  elseif entry1.opCapture == Operations.UNUSED then
    entry1.opCapture = Operations.OR2
    entry1.pol0 = aPol1
    entry1.sel1 = aCh2
    entry1.pol1 = aPol2
    return aCh1
  elseif entry2.opCapture == Operations.UNUSED then
    entry2.opCapture = Operations.OR2
    entry2.pol0 = aPol2
    entry2.sel1 = aCh1
    entry2.pol1 = aPol1
    return aCh2
  else
    return self.Result.NO_RESOURCE
  end
end


function PwmPreprocReg:getPreprocForAnd2Assertion(aCh1, aPol1, aCh2, aPol2)
  local entry1 = self.preprocRegistry[aCh1+1]
  local entry2 = self.preprocRegistry[aCh2+1]
  if entry1.opAssertion == Operations.AND2 and entry1.sel2 == aCh2 then
    return self.Result.REDUNDANT
  elseif entry2.opAssertion == Operations.AND2 and entry2.sel2 == aCh1 then
    return self.Result.REDUNDANT
  elseif entry1.opAssertion == Operations.UNUSED then
    entry1.opAssertion = Operations.AND2
    entry1.pol0 = aPol1
    entry1.sel2 = aCh2
    entry1.pol2 = aPol2
    return aCh1
  elseif entry2.opAssertion == Operations.UNUSED then
    entry2.opAssertion = Operations.AND2
    entry2.pol0 = aPol2
    entry2.sel2 = aCh1
    entry2.pol2 = aPol1
    return aCh2
  else
    return self.Result.NO_RESOURCE
  end
end


function PwmPreprocReg:getPreprocForAnd3Assertion(aCh1, aPol1, aCh2, aPol2, aCh3, aPol3)
  local entry1 = self.preprocRegistry[aCh1+1]
  if entry1.opAssertion == Operations.AND3 and entry1.sel1 == aCh2 and entry1.sel2 == aCh3 then
    return self.Result.REDUNDANT
  elseif entry1.opAssertion == Operations.UNUSED and entry1.sel1 == aCh2 then
    -- only support AND3 assertion if first two selectors are already configured
    entry1.opAssertion = Operations.AND3
    entry1.sel2 = aCh3
    entry1.pol2 = aPol3
    return aCh1
  else
    return self.Result.NO_RESOURCE
  end
end


function PwmPreprocReg:getPreprocForDirectCapture(aCh1)
  local entry = self.preprocRegistry[aCh1+1]
  if entry.opCapture == Operations.DIRECT then
    return aCh1
  elseif entry.opCapture == Operations.UNUSED then
    entry.opCapture = Operations.DIRECT
    return aCh1
  else
    return self.Result.NO_RESOURCE
  end
end


function PwmPreprocReg:generateAssertionCode()
  local code = ""
  for i = 0, NumChannels-1 do
    entry = self.preprocRegistry[i+1]
    if entry.opAssertion == Operations.AND2 then
      code = code .. (
        "plxEnableAndAssertion(%d, %d, %d, %d);" % {
          entry.sel0, entry.pol0,
          entry.sel2, entry.pol2
        }
      )
    elseif entry.opAssertion == Operations.AND3 then
      code = code .. (
        "plxEnableTripleAndAssertion(%d, %d, %d, %d, %d, %d);" % {
          entry.sel0, entry.pol0,
          entry.sel1, entry.pol1,
          entry.sel2, entry.pol2
        }
      )
    end
  end
  return code
end

return PwmPreprocReg