local Module = {}

function Module.getBlock(globals)
  local IncrementalEncoder = require('blocks.block').getBlock(globals)

  function IncrementalEncoder:getDirectFeedthroughCode()
    local Include = StringList:new()
    local InitCode = StringList:new()
    local OutputCode = StringList:new()
    local Require = ResourceList:new()

    local module = IncrementalEncoder:getInstanceNumber() + 1
    local pairs = Block.Mask.pairs
    local coding = Block.Mask.coding - 1
    local extrapolation = (Block.Mask.extrapolation == 1)
    local inputWidth = #Block.InputSignal[1]
    local blockSampleTime = Block.SampleTime[1]
    local resetCondition = Block.Mask.reset_condition-1
    local aSignal = Block.Mask.aSignal
    local bSignal = Block.Mask.bSignal
    local iSignal = Block.Mask.iSignal

    if (blockSampleTime == 0.0) then
       blockSampleTime = Block.Task.SampleTime[1]
    end

    Include:append("plexim/DigitalOut.h");
    Include:append("plexim/Encoder.h");

    local abPol;
    local abPolI;

    if resetCondition == 0 then
      abPol = { "DO_NINV", "DO_INV" }
    else
      abPol = { "DO_INV", "DO_NINV" }
    end

    -- register the hardware resources and generate initialization code per channel
    if module > 2 then
      return "A maximum of two Incremental Encoder blocks can be used in one model."
    end
    Require:add("Incremental encoder", module)
    for i = 1, #aSignal do
      local channel = aSignal[i]
      if channel >= 0 then
        Require:add("Digital output", channel);
        InitCode:append("setupDigitalOut(%i, DO_ENC%iA, %s);\n" % { channel, module, abPol[i] })
      end
    end
    for i = 1, #bSignal do
      local channel = bSignal[i]
      if channel >= 0 then
        Require:add("Digital output", channel);
        InitCode:append("setupDigitalOut(%i, DO_ENC%iB, %s);\n" % { channel, module, abPol[i] })
      end
    end

    local iPol = { "DO_NINV", "DO_INV" }

    for i = 1, #iSignal do
      local channel = iSignal[i]
      if channel >= 0 then
        Require:add("Digital output", channel);
        InitCode:append("setupDigitalOut(%i, DO_ENC%iI, %s);\n" % { channel, module, iPol[i] })
      end
    end


    InitCode:append( "setupEncoder(ENC%i, %s, %i, %i);\n" %
      { module, blockSampleTime, pairs, coding })

    -- generate output code
    local angle = Block.InputSignal[1][1]
    OutputCode:append("updateEncoder(ENC%i, %s);\n" % { module, angle })

    return {
      Include = Include,
      Require = Require,
      InitCode = InitCode,
      OutputCode = OutputCode
    }
  end
  
  return IncrementalEncoder
end  
return Module
