/*
   Copyright (c) 2016 by Plexim GmbH
   All rights reserved.

   A free license is granted to anyone to use this software for any legal
   non safety-critical purpose, including commercial applications, provided
   that:
   1) IT IS NOT USED TO DIRECTLY OR INDIRECTLY COMPETE WITH PLEXIM, and
   2) THIS COPYRIGHT NOTICE IS PRESERVED in its entirety.

   THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
   OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
   FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
   AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
   LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
   OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
   SOFTWARE.
 */

#ifndef ANALOGIN_H_
#define ANALOGIN_H_

#include "plexim/hw_wrapper.h"

#ifdef __cplusplus
extern "C"
{
#endif

typedef enum
{
   V_AIN_10V,
   V_AIN_5V
} AnalogInputVoltage;

void plxSetAnalogInputVoltage(AnalogInputVoltage aValue);

AnalogInputVoltage plxGetAnalogInputVoltageSpan(void);

/**
 * @brief Setup of the n-th analog input.
 * 
 *	
 * @param aIndex ID of analog input.
 * @param aScale Scaling factor.
 * @param aOffset Offset.
 * @param aTrigSource Trigger Source.
 * @param aTrigChannel Trigger Channel.
 * @param aTrigDelay Trigger Delay Value [s].
 */
void setupAnalogIn(int aIdx, float aScale, float aOffset, int aTrigSource, int aTrigChannel, float aTrigDelay);

/**
 * @brief Returns the conversion result of the n-th analog input.
 * 
 *	
 * @param n ID of analog input.
 */   
#define getAnalogIn(n) (*(plxIo.ADCInput + (n)))

#ifdef __cplusplus
}
#endif

#endif /* ANALOGIN_H_ */
