local Module = {}

local static = {}

local Utils = require('blocks.BlockUtils')

function Module.getBlock(globals)
  local SimpleGateSignalCombination = require('blocks.block').getBlock(globals)

  function SimpleGateSignalCombination:getDirectFeedthroughCode()
    local InitCode = StringList:new()
    local OutputSignal = {}
    local OutputMetaData = {}
    local isConst0 = {}
    local canUseFpga = true
    local needsAssertion = {}
    local preprocReg = Target.Coder.getPwmPreprocReg()

    local width = #Block.InputSignal[1]
    for idx = 1, width do
      needsAssertion[idx] = true
    end
    if #Block.InputSignal[2] ~= width then
      return nil, { message = "Gate signals must have the same width.", level = 1 }
    end
    for idx = 1, 2 do
      isConst0[idx] = {}
      for s = 1, width do
        local signalValue = Utils.stringToNumber(Block.InputSignal[idx][s], true)
        isConst0[idx][s] = signalValue == 0
        needsAssertion[s] = needsAssertion[s] and not isConst0[idx][s]
        if not isConst0[idx][s] then
          if Block.InputMetaData[idx] == nil 
            or Block.InputMetaData[idx][s] == nil 
            or Block.InputMetaData[idx][s]['port'] == nil 
            or Block.InputMetaData[idx][s]['polarity'] == nil 
            then
            canUseFpga = false
          end
        end
      end
    end


    for idx = 1, 2 do
      OutputSignal[idx] = Block.InputSignal[idx]
      OutputMetaData[idx] = {}
      if canUseFpga and Block.InputMetaData[idx] then
        for s = 1, #Block.InputSignal[idx] do
          if Block.InputMetaData[idx][s] then
            OutputMetaData[idx][s] = Block.InputMetaData[idx][s]
          else
            OutputMetaData[idx][s] = {}
          end
        end
      else
        for s = 1, #Block.InputSignal[idx] do
          table.insert(OutputMetaData[idx], {})
        end
      end
    end

    local inputsOnSameBoard = canUseFpga
    if canUseFpga == true and Target.Name == "PLECS RT Box 3" then
      for idx = 1, width do
        if (not isConst0[1][idx]) and (not isConst0[2][idx]) then 
          local channel1 = tonumber(OutputMetaData[1][idx]['port'])
          local channel2 = tonumber(OutputMetaData[2][idx]['port'])
          if (channel1 >= 32 and channel2 <32) or (channel1 < 32 and channel2 >= 32) then
            inputsOnSameBoard = false
            break
          end
        end
      end
    end

    for idx = 1, width do
      local channel1 = tonumber(Block.InputMetaData[1][idx]['port'])
      local channel2 = tonumber(Block.InputMetaData[2][idx]['port'])
      if not isConst0[1][idx] and (channel1 ~= nil) then
        local preproc = preprocReg:getPreprocForDirectCapture(channel1)
        if preproc == preprocReg.Result.NO_RESOURCE then
          return "PWM channel %d is connected to too many gate inputs." % { channel1 }
        end
      end
      if not isConst0[2][idx] and (channel2 ~= nil) then
        local preproc = preprocReg:getPreprocForDirectCapture(channel2)
        if preproc == preprocReg.Result.NO_RESOURCE then
          return "PWM channel %d is connected to too many gate inputs." % { channel2 }
        end
      end
    end

    local assertionCode = StringList:new()
    local assertions = Block.Mask.assertions - 1
    if assertions == 1 then
      for idx = 1, width do
        if needsAssertion[idx] then
          local useFpgaPreproc = false
          local preproc
          if canUseFpga and inputsOnSameBoard then
            useFpgaPreproc = true
            local channel1 = tonumber(Block.InputMetaData[1][idx]['port'])
            local channel2 = tonumber(Block.InputMetaData[2][idx]['port'])
            local polarity1 = Block.InputMetaData[1][idx]['polarity']
            local polarity2 = Block.InputMetaData[2][idx]['polarity']
            preproc = preprocReg:getPreprocForAnd2Assertion(channel1, polarity1, channel2, polarity2)
            if preproc == preprocReg.Result.NO_RESOURCE then
              useFpgaPreproc = false
            elseif preproc == preprocReg.Result.REDUNDANT then
              goto continue
            end
          end
          if useFpgaPreproc then
            assertionCode:append("plxCheckAssertion(%i)" % { preproc })
          else          
            -- fall back to preprocessing on CPU
            assertionCode:append("((%s) + (%s) < 1.000001)" % {
              Block.InputSignal[1][idx], Block.InputSignal[2][idx]
            })
          end
        end
        ::continue::
      end
    end
    if #assertionCode > 0 then
      OutputSignal[3] = { "%s" % { table.concat(assertionCode, "&&") }}
    else
      OutputSignal[3] = { "1" }
    end
    OutputMetaData[3] = {{}}

    return {
      InitCode = InitCode,
      OutputSignal = OutputSignal,
      OutputMetaData = OutputMetaData,
    }
  end

  return SimpleGateSignalCombination
end

return Module
