*** Variables ***
${RTBOX}=  RTBox.local
${RTBOX_TYPE}=  PLECS RT Box 1
${HOST_PC_IP_ADDRESS}=  255.255.255.255
${RPC_METHOD}=  XML
${UDP_SAMPLE_TIME}=  ${0.001}
${UDP_signal_width}=  ${5}
${UDP_HEADER}=  [time, Vin (V), iL (A), Vout (V), iLref (A)]
${MODEL_NAME}=  boost_converter

*** Settings ***
Library  ./PlecsXMLJSONRPC.py    ${RPC_METHOD}
Library  ./boost_converter.py

*** Keywords ***
Compile and upload
   [Arguments]    ${modelName}  ${subsystemName}  &{codegenVars}
   rtBoxSetupServer  ${RTBOX}
   plecsGenerateCode        ${modelName}   ${subsystemName}   ${RTBOX_TYPE}   &{codegenVars}
   rtBoxUpload    ${CURDIR}${/}${modelName}   ${subsystemName}

*** Test Cases ***
Load profile and Data Logging
    plecsLoadModel      ${MODEL_NAME}  
    Compile and upload	${MODEL_NAME}  Plant_and_Controller
    ...  Ts_udp=${UDP_SAMPLE_TIME}  host_PC_IP_address=${HOST_PC_IP_ADDRESS}
    ...  simMode=${0}
    plecsGetCircuitBitmap  Plant_and_Controller
    rtBoxBackgroundLogging  ${True}  ${UDP_signal_width}  ${UDP_SAMPLE_TIME}
    ...  background_log.csv  ${UDP_HEADER}
    ${value}=  rtBoxBackgroundLoggingEnabled
    rtBoxStart
    sleep  2
    rtBoxSetValue	Value1  90.0
    ${time}=  rtBoxGetValue   Capture1   0   2.0
    ${iLref}=  rtBoxGetValue   Capture2   0   2.0
    ${iL}=  rtBoxGetValue   Capture3   0   2.0
    plotData  ${time}  ${iLref}  iLref  time (s)  current (A)
    ...  current step response  True  -  r
    plotData  ${time}  ${iL}  iL  time (s)  current (A)
    ...  current step response  False  -  b
    rtBoxBackgroundLogging  ${False}
    rtBoxStop
