#ifndef MODBUS_CLIENT_H_
#define MODBUS_CLIENT_H_

#include <stdint.h>

#pragma pack(push, 4)
struct ModbusClientSetupMsg {
   uint32_t mMsg;
   uint32_t mMsgLength;
   uint32_t mClientInstance;
   uint32_t mBufferOffset;
   uint32_t mTimeout;
   uint32_t mRetries;
   uint32_t mIpAddress;
   uint16_t mPort;
   uint16_t mUnitIdentifier;
   uint16_t mNumBitInputs;
   uint16_t mNumRegInputs;
   uint16_t mNumBitOutputs;
   uint16_t mNumRegOutputs;
   uint16_t mData[1]; // placholder dummy array of length 1
};
#pragma pack(pop)

#ifdef __cplusplus
extern "C"
{
#endif

void plxSetupModbusClient(struct ModbusClientSetupMsg* aMsg);
uint16_t* plxGetModbusBuffer(void);
void plxTriggerModbusClient(uint32_t aClientInstance);
uint32_t plxResolveHostname(const char* aHostname);

#ifdef __cplusplus
}
#endif

#endif
