/*
   Copyright (c) 2018 by Plexim GmbH
   All rights reserved.

   A free license is granted to anyone to use this software for any legal
   non safety-critical purpose, including commercial applications, provided
   that:
   1) IT IS NOT USED TO DIRECTLY OR INDIRECTLY COMPETE WITH PLEXIM, and
   2) THIS COPYRIGHT NOTICE IS PRESERVED in its entirety.

   THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
   OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
   FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
   AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
   LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
   OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
   SOFTWARE.
 */
#ifndef UDP_H_
#define UDP_H_

#include <stdint.h>
#include "plexim/HIL_Framework.h"

#pragma pack(push, 4)
   struct UdpRequestPortsMsg {
      uint32_t mMsg;
      uint32_t mMsgLength;
      uint32_t mNumPorts;
      uint16_t mPorts[1]; // placeholder dummy array of length 1
   };
#pragma pack(pop)

void setupUdpTx(void);
int udpSendMessage(void* aData, uint32_t aSize);
void plxSendQueuedUdpMessages(void);
void plxRegisterUdpRxPorts(struct UdpRequestPortsMsg* aRequestPortsMsg, void** aBuffers, 
                           const uint16_t* aBufferLengths, unsigned char* aUpdateFlags, int* aIdzs);
void plxHandleUdpMessage(const struct UdpReceiveMsg* aMsg);
uint32_t plxResolveHostname(const char* aHostname);
#endif
