/*
 * hw_wrapper.h
 *
 *  Created on: Dec 23, 2014
 *      Author: Oliver
 */

#ifndef HW_WRAPPER_H_
#define HW_WRAPPER_H_

#include <stdint.h>

#ifdef __cplusplus
extern "C"
{
#endif

#define printk xil_printf
#define plxPrintf xil_printf
#define plxUserMessage(aSeverity, ...) xil_printf(__VA_ARGS__)

typedef int PLX_BOOL;

#ifndef FALSE
enum
{
   FALSE,
   TRUE
};
#endif

typedef enum
{
   PLX_SUCCESS,
   PLX_FAILURE
} PlxStatus;

typedef enum
{
   VOUT_3V3,
   VOUT_5V0
} DigitalOutVoltage;

typedef enum
{
   V_AIN_10V,
   V_AIN_5V
} AnalogInputVoltage;

typedef enum
{
   PWM_NEGATIVE_POLARITY,
   PWM_POSITIVE_POLARITY
} PWMPolarity;

typedef uint32_t u32;
typedef int32_t s32;
typedef int16_t s16;
typedef uint16_t u16;
typedef uint8_t u8;

typedef struct {
   float * DACOutput;
   uint32_t * PWMTrigger;
   uint16_t * PWMOutput;
   uint32_t * ENCOutput;
   uint8_t* SPIEnable;
   uint16_t* PowerstageReset;
   float * SFPOutput;
   uint16_t* SPIOutput0;
   uint16_t* SPIOutput1;
   float* NanostepVoltageOutput;
} PlxIoOut;

typedef struct {
   uint32_t* DiffEncInput;
   uint32_t* DigitalInput;
   uint32_t* Assertions;
   uint16_t* ActiveCountPWM;
   uint8_t* PWMFallingEdges;
   float* ADCInput;
   float* SFPInput;
   uint16_t* SPIInputState;
   uint16_t* SPIInput0;
   uint16_t* SPIInput1;
   uint8_t* PowerstageState;
   float* PWMCycleRate;
   float* NanostepCurrentInput;
   float* NanostepILVCInput;
   uint8_t* any_overflow;
} PlxIoIn;

extern PlxIoOut plxIoOut;
extern PlxIoIn plxIoIn;

extern float plxPWMCycleRate;
int postInitCode(void);
void plxWaitForIrqAck(void);
void plxStopTimer(void);
void xil_printf(const char *ctrl1, ...);
void plxSetAnalogInputVoltage(AnalogInputVoltage aValue);
AnalogInputVoltage plxGetAnalogInputVoltageSpan(void);
void plxSetDigitalOutVoltage(DigitalOutVoltage aValue);
DigitalOutVoltage plxGetDigitalOutVoltage(void);
void plxSetupAnalogSampling(u32 aMode, u32 aTicks, double aStepSize);
void plxSetBufferAdresses(void);
void plxUpdatePWMCycleRate(void);

#ifdef __cplusplus
}
#endif

#endif /* HW_WRAPPER_H_ */
