/*
   Copyright (c) 2025 by Plexim GmbH
   All rights reserved.

   A free license is granted to anyone to use this software for any legal
   non safety-critical purpose, including commercial applications, provided
   that:
   1) IT IS NOT USED TO DIRECTLY OR INDIRECTLY COMPETE WITH PLEXIM, and
   2) THIS COPYRIGHT NOTICE IS PRESERVED in its entirety.

   THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
   OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
   FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
   AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
   LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
   OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
   SOFTWARE.
 */

#ifndef NANOSTEP_OUT_H_
#define NANOSTEP_OUT_H_

#include "plexim/AnalogOut.h"

/**
* @brief Global setup for Nanostep DAC modules.
 * 
 *	
 * @param aSpan DAC output span.
 */ 
int plxSetupNanostepDACs(DACSpan aSpan);

int plxGetNanostepDacSpan(void);

int plxGetNumNanostepDACs(void);
void plxSetupNanostepDAC(int aIdx, int aSource, double aGain, double aOffset);

void plxSetNanostepDAC(int aIdx, int aAddr, int aValue);
int  plxGetNanostepDAC(int aIdx, int aAddr);

void plxSelectNanostepSignal(int aIdx, int aSource);
void plxSetupNanostepTrigger(int aPatternSel, int aNumBeats, int aDecimation);

#endif
