/*
   Copyright (c) 2020 by Plexim GmbH
   All rights reserved.

   A free license is granted to anyone to use this software for any legal
   non safety-critical purpose, including commercial applications, provided
   that:
   1) IT IS NOT USED TO DIRECTLY OR INDIRECTLY COMPETE WITH PLEXIM, and
   2) THIS COPYRIGHT NOTICE IS PRESERVED in its entirety.

   THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
   OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
   FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
   AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
   LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
   OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
   SOFTWARE.
 */

#ifndef RESOLVEROUT_H_
#define RESOLVEROUT_H_

#include "plexim/hw_wrapper.h"

#define RESOLVER_SIN0 33
#define RESOLVER_COS0 16
#define RESOLVER_SIN1 35
#define RESOLVER_COS1 18

extern int plxResolverOutNumStep;
 
int setupResolverOut(int aModule, float aGain, float aOffset, int aInterpolation);
void setupResolverOutSteps(int aSteps);
void finishResolverOutSetup(void);

#define setResolverOutSinCos(aModule, aValue) { \
   *(plxIoOut.DACOutput+RESOLVER_SIN##aModule) = sin(aValue); \
   *(plxIoOut.DACOutput+RESOLVER_COS##aModule) = cos(aValue); }

#define setResolverOutInterpolated(aModule, aValue) { \
   static const double scale = pow(2.0, 30) / M_PI; \
   static int32_t oldPos; \
   double angle = aValue; \
   if ((angle < 0.0) || (angle >= (2.0 * M_PI))) { \
     angle = fmod(angle, 2.0 * M_PI); \
     if (angle < 0.0) \
        angle += 2.0 * M_PI; \
   } \
   int32_t newPos = angle * scale; \
   int32_t diff = newPos - oldPos; \
   struct {signed int x:31} s; \
   diff = s.x = diff; \
   int32_t stepVal = diff / plxResolverOutNumStep; \
   *(int32_t*)(plxIoOut.DACOutput+RESOLVER_SIN##aModule) = oldPos; \
   *(int32_t*)(plxIoOut.DACOutput+RESOLVER_COS##aModule) = stepVal; \
   oldPos = newPos; }

#endif
