-- OrderedSet.lua
-- 
-- Copyright (c) 2023 Plexim GmbH
-- All rights reserved.

-- An ordered set contains elements in the order in which they were first
-- inserted

local OrderedSet = {
  -- mKeys = {}
  -- mSet = {}
}

function OrderedSet:new()
  local o = { mKeys = {}, mSet = {}}
  self.__index = self
  setmetatable(o, self)
  return o
end

function OrderedSet:keys()
  return self.mKeys
end

function OrderedSet:insert(aKey)
  if not self.mSet[aKey] then
    self.mSet[aKey] = true
    self.mKeys[#self.mKeys + 1] = aKey
  end
end

function OrderedSet:hasKey(aKey)
  return self.mSet[aKey]
end

function OrderedSet:size()
  return #self.mKeys
end

return OrderedSet
