local Module = {}

local Utils = require('blocks.BlockUtils')

function Module.getBlock(globals)
  local NanostepScope = require('blocks.block').getBlock(globals)

  function NanostepScope:getDirectFeedthroughCode()
    local InitCode = StringList:new()
    local OutputCode = StringList:new()
    local Require = ResourceList:new()

    local moduleId = NanostepScope:getInstanceNumber()
    if moduleId > 0 then
      return "Only one Nanostep scope can be used in a model."
    end
    Require:add("NanostepScope", moduleId + 1)
    
    for i = 1, #Block.InputSignal do
      for s = 1, #Block.InputSignal[i] do
        if Utils.isUnconnectedInputSignal(i, s) then
          return "A Nanostep scope must be connected to a Nanostep probe block."
        end
        local metaData = Block.InputMetaData[i][s]
        if metaData ~= nil and metaData['sourceInfo'] ~= nil 
                           and metaData['sourceInfo']['fromFPGA'] == 1 then
          local metaGain = metaData['sourceInfo']['gain'] 
          local nanostepProbe = metaData['sourceInfo']['nanostepProbe']
          local nanostepProbeType = metaData['sourceInfo']['nanostepProbeType']
          Target.Coder.RegisterNanostepScopeSignal(nanostepProbeType, nanostepProbe, metaGain)
          -- Check if the input is the Nanostep inductor current, in which case we may need to set up
          -- an 'absolute' operator on its value. This is the case if nanostepProbe is 0, 1, 2, 12, 13 or 14.
          local probingInductorCurrent = (nanostepProbe < 3) or (nanostepProbe >= 12 and nanostepProbe < 15)
          if probingInductorCurrent then
            -- Check if the signal metadata specifies and abs operation.
            if metaData['sourceInfo']['useAbs'] == 1 then
              -- Infer the Nanostep solver instance and partial from the value of nanostepProbe.
              local solverInstance = nanostepProbe // 12
              local inductorIndex = (nanostepProbe - solverInstance * 12)
              InitCode:append("plxSetupNanostepDACAbsIL(%i, %i);\n" % { solverInstance, inductorIndex })
            end
          end
        else
          return "Implementation error: signal contains no nanostep information."
        end
      end
    end
    return {
      Include = {},
      InitCode = InitCode,
      OutputCode = OutputCode,
      Require = Require,
    }
  end
  
  return NanostepScope
end  
return Module
