HOST_NAME       = "rtbox-123.local";
HOST_ADDRESS	= "http://" + HOST_NAME + ":9998/RPC2";
MODEL_NAME		= "rlc_network_scripting";

%Initialize server and load executable
server = jsonrpc(HOST_ADDRESS);
    
f = fopen('rlc_network_scripting_codegen/' + MODEL_NAME + '.elf', 'rb');
fprintf("Uploading executable\n");
server.rtbox.load(matlab.net.base64encode(fread(f, '*uint8')));
fclose(f);
    
fprintf("Starting executable\n");
server.rtbox.start();
fprintf("Real-time simulation running\n");

%  List of all Programmable Value and Data Capture blocks in the current model
inputblocks = server.rtbox.getProgrammableValueBlocks();
outputblocks = server.rtbox.getDataCaptureBlocks();
fprintf("Available input blocks are:\n");
disp(inputblocks);
fprintf("Available output blocks are:\n");
disp(outputblocks);

% Sending data to the real-time simulation
Vin = 2;
fprintf("Setting Vin as %.2fV\n", Vin);
server.rtbox.setProgrammableValue('Input', {Vin});

% Getting data from the real-time simulation
while server.rtbox.getCaptureTriggerCount('Capture1')==0
  fprintf("Waiting for data\n");
  pause(1);
end;
data1 = getfield(server.rtbox.getCaptureData('Capture1'), 'data');
data2 = getfield(server.rtbox.getCaptureData('Capture2'), 'data');

Vm = data1(1,:);
Am = data1(2,:);
VmMax = data2(1,1);

fprintf("Stopping executable\n");
server.rtbox.stop();
fprintf("Real-time simulation stopped\n");

fprintf("Max value of Vm = %.2fV\n", VmMax);
