/*
   Copyright (c) 2019 by Plexim GmbH
   All rights reserved.

   A free license is granted to anyone to use this software for any legal
   non safety-critical purpose, including commercial applications, provided
   that:
   1) IT IS NOT USED TO DIRECTLY OR INDIRECTLY COMPETE WITH PLEXIM, and
   2) THIS COPYRIGHT NOTICE IS PRESERVED in its entirety.

   THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
   OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
   FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
   AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
   LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
   OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
   SOFTWARE.
 */

#ifndef DIGITAL_OVERRIDE_H_
#define DIGITAL_OVERRIDE_H_

#include <stdint.h>
#include "plexim/hw_wrapper.h"
#include "plexim/PowerstageProtection.h"

#ifdef __cplusplus
extern "C"
{
#endif

extern u32 OvrEnReg;
extern u32 OvrValReg;

void plxInitDigitalOverride(void);

void plxSyncDigitalOverrides(void);

/**
* @brief Set the values that a digital output pin should be overridden to.
 * 
 * @param n ID of digital output.
 * @param x Defines logical level the output is overridden to.
 */
#define setDOverrideVal(n, x) \
{ \
    if (x) \
       OvrValReg |= (1 << (n)); \
    else \
       OvrValReg &= ~((1 << (n))); \
}

/**
* @brief If x, enable overriding the value of pin n. Else disable it.
 * 
 * @param n ID of digital output.
 * @param x The condition required for overriding.
 */
#define setDOverrideEn(n, x) \
{ \
    if (x) \
       OvrEnReg |= (1 << (n)); \
    else \
       OvrEnReg &= ~((1 << (n))); \
}

#ifdef __cplusplus
}
#endif

#endif
