/*
   Copyright (c) 2022 by Plexim GmbH
   All rights reserved.

   A free license is granted to anyone to use this software for any legal
   non safety-critical purpose, including commercial applications, provided
   that:
   1) IT IS NOT USED TO DIRECTLY OR INDIRECTLY COMPETE WITH PLEXIM, and
   2) THIS COPYRIGHT NOTICE IS PRESERVED in its entirety.

   THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
   OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
   FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
   AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
   LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
   OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
   SOFTWARE.
 */
#ifndef POWERSTAGE_PROTECTION_H_
#define POWERSTAGE_PROTECTION_H_

#ifdef __cplusplus
extern "C"
{
#endif

#include "plexim/hw_wrapper.h"

typedef enum PLX_POWERSTAGE_UNITS
{
   PLX_PSP_UNIT1,
   PLX_PSP_UNIT2,
   PLX_PSP_UNIT3,
   PLX_PSP_UNIT4,
   PLX_PSP_UNIT_NONE = 7,
} PlxPowerstageUnit;

typedef enum PLX_POWERSTAGE_RESETS
{
   PLX_PSP_MANUAL_RESET,
   PLX_PSP_AUTOMATIC_RESET,
} PlxPowerstageReset;

extern uint16_t plxPowerstageValue;

#define plxUpdatePowerstage(unit, aReset, aTrigger) { plxPowerstageValue = ((plxPowerstageValue & ~(0x101 << (unit))) | ((!!(aReset)) << (unit+8)) | ((!!(aTrigger)) << (unit))); *plxIoOut.PowerstageReset = plxPowerstageValue; }
#define plxGetPowerstageState(unit) ((*plxIoIn.PowerstageState & (1 << (unit))) != 0)
void plxInitPowerstageProtection(void);
void plxSetupPowerstageProtection(PlxPowerstageUnit aPowerstageId, int aInputId, int aInputId2, int aInputId3, PlxPowerstageReset aReset);
void plxEnableUnconfiguredPowerstages(void);
void plxDisablePowerstages(void);

#ifdef __cplusplus
}
#endif

#endif
