/*
   Copyright (c) 2022 by Plexim GmbH
   All rights reserved.

   A free license is granted to anyone to use this software for any legal
   non safety-critical purpose, including commercial applications, provided
   that:
   1) IT IS NOT USED TO DIRECTLY OR INDIRECTLY COMPETE WITH PLEXIM, and
   2) THIS COPYRIGHT NOTICE IS PRESERVED in its entirety.

   THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
   OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
   FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
   AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
   LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
   OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
   SOFTWARE.
 */
#ifndef ENDAT_H
#define ENDAT_H

#include <stdint.h>

void plxInitEndat(uint8_t aResolution, double aMaxClockPulseWidth);
void plxUpdateEndat(double aPos);

/**
 * @brief plxWriteEndatMemory Write data to EnDat encoder memory
 * @param aMrsCode The memory area (MRS code) to write to
 * @param aAddress The address within the memory area to write to (0-255)
 * @param aValue The value to write to the given address in the given memory area (16 bit)
 */
void plxWriteEndatMemory(uint8_t aMrsCode, uint8_t aAddress, uint16_t aValue);

/**
 * @brief plxEndatConnect Connects the physical EnDat interface to the FPGA
 */
void plxEndatConnect(void);

/**
 * @brief plxEndatConnect Disconnects the physical EnDat interface from the FPGA. No EnDat commands are processed.
 */
void plxEndatDisconnect(void);

#endif
