local Module = {}

local static = {}

local Utils = require('blocks.BlockUtils')

function Module.getBlock(globals)
  local NPCGateSignalCombination = require('blocks.BaseGateSignalCombination').getBlock(globals, 5)

  function NPCGateSignalCombination:getDirectFeedthroughCode()

    NPCGateSignalCombination:forwardInputs({{ 1, 2 }, { 3, 4 }})

    NPCGateSignalCombination:generateDirectInput(2)
    NPCGateSignalCombination:generateDirectInput(3)
    
    local minVar12 = NPCGateSignalCombination:generateAndInput(1, 2)
    local minVar43 = NPCGateSignalCombination:generateAndInput(4, 3)

    NPCGateSignalCombination:generateTripleAndAssertion(1, 2, 3, minVar12)
    NPCGateSignalCombination:generateTripleAndAssertion(4, 3, 2, minVar43)

    self.OutputSignal[3] = { NPCGateSignalCombination:getAssertionCode() }
    self.OutputMetaData[3] = {{}}

    if string.len(NPCGateSignalCombination.errorMsg) > 0 then
      return nil, { message = NPCGateSignalCombination.errorMsg, level = 2}
    end
    return {
      InitCode = self.InitCode,
      OutputSignal = self.OutputSignal,
      OutputCode = self.OutputCode,
      OutputMetaData = self.OutputMetaData,
    }
  end
  
  return NPCGateSignalCombination
end

return Module
