local Module = {}

local static = {}

local Utils = require('blocks.BlockUtils')

function Module.getBlock(globals)
  local TTypeGateSignalCombination = require('blocks.BaseGateSignalCombination').getBlock(globals, 5)

  function TTypeGateSignalCombination:getDirectFeedthroughCode()

    TTypeGateSignalCombination:forwardInputs({{ 1, 2 }, { 3, 4 }})

    TTypeGateSignalCombination:generateDirectInput(1)
    TTypeGateSignalCombination:generateDirectInput(4)

    TTypeGateSignalCombination:generateOrInput(2, 1)
    TTypeGateSignalCombination:generateOrInput(3, 4)

    TTypeGateSignalCombination:generateAndAssertion(1, 3)
    TTypeGateSignalCombination:generateAndAssertion(2, 4)
    TTypeGateSignalCombination:generateAndAssertion(4, 1)
    
    self.OutputSignal[3] = { TTypeGateSignalCombination:getAssertionCode() }
    self.OutputMetaData[3] = {{}}

    if string.len(TTypeGateSignalCombination.errorMsg) > 0 then
      return nil, { message = TTypeGateSignalCombination.errorMsg, level = 2}
    end

    return {
      InitCode = self.InitCode,
      OutputSignal = self.OutputSignal,
      OutputCode = self.OutputCode,
      OutputMetaData = self.OutputMetaData,
    }
  end
  
  return TTypeGateSignalCombination
end

return Module
