import sys
from io import BytesIO
import base64
import matplotlib.pyplot as plt
import numpy as np
from robot.api import logger


class boost_converter:
    ROBOT_LIBRARY_SCOPE = 'SUITE'

    def __init__(self):
        self._plot = plt
        self._plot.figure(figsize=(5, 5), dpi=150)

    def __del__(self):
        self._plot.close()

    def plotData(self, xdata, ydata, legend, xlabel, ylabel, title, holdOn=False, linestyle='-', color='k'):
        xValues = np.asarray(xdata)
        yValues = np.asarray(ydata)
        self._plot.title(title)
        self._plot.xlabel(xlabel)
        self._plot.ylabel(ylabel)
        self._plot.plot(xValues, yValues, label=legend, linestyle=linestyle, color=color)
        self._plot.legend()
        self._plot.grid(True)
        if not holdOn:
            tmpFile = BytesIO()
            self._plot.savefig(tmpFile, format='svg')
            encodedFigure = base64.b64encode(tmpFile.getvalue()).decode('utf-8')
            logger.info('<img src="data:image/svg+xml;base64,' + encodedFigure + '">', html=True)
            self._plot.close()
            self._plot = None
            self._plot = plt
