import socket
import time
import base64               # deserialise MAT-file contents for JSON-RPC

# The RT Box listens to XML-RPC connections on TCP port 9998
# The following Python code initiates an XML-RPC connection to the RT Box:
# Syntax for Python 3.x

HOST_NAME       = "rtbox-123.local"
ip              = socket.gethostbyname(HOST_NAME)
HOST_ADDRESS    = "http://" + ip + ":9998/RPC2"
MODEL_NAME      = "data_logging"
METHOD          = "XML"	  # choose "XML" or "JSON"

#Initialize server and load executable
if METHOD == "XML":
    import xmlrpc.client        # for XML-RPC
    server = xmlrpc.client.Server(HOST_ADDRESS)
elif METHOD == "JSON":
    import jsonrpc_requests     # for JSON-RPC
    server = jsonrpc_requests.Server(HOST_ADDRESS)

with open(MODEL_NAME + "_codegen/" + MODEL_NAME + ".elf", "rb") as f:
  print("Uploading executable")
  server.rtbox.load(base64.b64encode(f.read()).decode())
f.closed

print("Starting executable")
server.rtbox.start()
print("Real-time simulation running")

# Getting data from the real-time simulation
while server.rtbox.getCaptureTriggerCount('Capture1')==0:
  print("Waiting for data")
  time.sleep(0.1)

data = server.rtbox.getCaptureData('Capture1')
data_capture = [row[0] for row in data['data']]

print("Stopping executable")
server.rtbox.stop();
print("Captured Data are:\n", data_capture)