#ifndef MODBUS_SERVER_H_
#define MODBUS_SERVER_H_

#include <stdint.h>

#pragma pack(push, 4)
struct ModbusServerSetupMsg {
   uint32_t mMsg;
   uint32_t mMsgLength;
   uint32_t mBufferOffset;
   uint16_t mPort;
   uint16_t mNumBitInputs;
   uint16_t mNumRegInputs;
   uint16_t mNumBitOutputs;
   uint16_t mNumRegOutputs;
   uint16_t mData[1]; // placholder dummy array of length 1
};
#pragma pack(pop)

#ifdef __cplusplus
extern "C"
{
#endif

void plxSetupModbusServer(struct ModbusServerSetupMsg* aMsg);
uint16_t* plxGetModbusBuffer(void);

#ifdef __cplusplus
}
#endif

#endif
